# $Id: Request.pm 43917 2015-09-22 08:37:08Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Login/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Login::Request;

use Xyzzy::Util qw(parse_bool);
use Aselect::URL qw(normalize_url valid_http_url);
use Aselect::UI::Ticket;

use Aselect::Request -self;

param rid => sub {
	my $self = shift;
	if(defined) {
		my $crypto = $self->crypto;
		my (undef, undef, $origin, $id, $url) =
			eval { $crypto->check_token('r', $_, $self->cfg->request_timeout) };
		die $self->errorpage('rid', "rid: $@") if $@;
		$self->requestor_origin($origin);
		$self->requestor_id($id);
		$self->requestor_url($url);
	} else {
		$self->requestor_origin(undef);
		$self->requestor_id(undef);
		$self->requestor_url(undef);
	}
};

param service => sub {
	return unless defined;

	my $self = shift;
	my $cfg = $self->cfg;

	$_ = normalize_url($_);
	unless(valid_http_url($_)) {
		warn "rejecting '$_' as a valid service because it is malformed\n";
		die $self->errorpage('service');
	}

	my $re = $cfg->urlfilter;
	unless($_ =~ $re) {
		warn "rejecting '$_' as a valid service because it does not match the configured ServiceFilter\n";
		die $self->errorpage('service');
	}

	$re = $cfg->servicefilter;
	unless($_ =~ $re) {
		warn "rejecting '$_' as a valid service because it does not match the list of allowed services configured under ServiceFilter\n";
		die $self->errorpage('service');
	}

	$_ = $self->apply_https_everywhere($_);
};

param lt => sub {
	my $self = shift;
	$_ = eval { $self->cur_session->check_lt($_, $self->cfg->request_timeout); 1 };
};

sub nonce {
	return super || $self->lt;
}

field effective_warn => sub {
	my $self = shift;
	return 'true' if $self->bool_param('warn');
	return 'false' unless defined $self->rid || defined $self->service;
	return $self->new_warn;
};

field effective_remember => sub {
	my $self = shift;
	return 'true' unless defined $self->rid || defined $self->service;
	return bool_string($self->bool_param('remember') // 0)
		if $self->nonce;
	return $self->new_remember;
};

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

field requestor_origin => sub { shift->rid; return };
field requestor_id => sub { shift->rid; return };
field requestor_url => sub { shift->rid; return };

field bare_url => sub {
	my $self = shift;
	if(my $requestor_url = $self->requestor_url) {
		return $requestor_url;
	} elsif(my $service = $self->service) {
		return $service;
	} else {
		return $self->script_url . '/status';
	}
};
