# $Id: Request.pm 46234 2017-02-14 10:23:46Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Session/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Session::Request;

use Aselect::Request -self;

field uid => sub {
	my $self = shift;
	return undef if $self->renew;
	my $uid = $self->new_session->uid;
	return undef unless defined $uid;
	return undef if $uid eq '';
	return undef unless $self->dir->search($uid)->count;
	return $uid;
};

use constant effective_remember => 'false';
