# $Id: Request.pm 37888 2012-09-28 08:00:04Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Settings/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Settings::Request;

use Aselect::Request -self;

field new_warn => sub {
	my $self = shift;
	return $self->cur_warn unless $self->nonce;
	return bool_string($self->bool_param('warn')) // $self->cur_warn;
};

field new_remember => sub {
	my $self = shift;
	return $self->cur_remember unless $self->nonce;
	return bool_string($self->bool_param('remember')) // $self->cur_remember;
};

field new_spnego => sub {
	my $self = shift;
	return $self->cur_spnego unless $self->nonce;
	return $self->param('spnego') // $self->cur_spnego;
};
