# $Id: Error.pm 34999 2011-06-09 09:30:44Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/Server/Error.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::Server::Error;

use Aselect::Error;

use Aselect::WS::Responder::Request -self;

field code;
field message;

field response => sub {
	my $self = shift;

	my $err = new Aselect::Error($self->code);

	my $message = $self->message;
	$message =~ s/\s+$//;
	if($message) {
		return {result_code => $err->code, message => $message};
	} elsif($message = $err->message) {
		return {result_code => $err->code, message => $message, description => $err->description};
	} else {
		return {result_code => $err->code};
	}
};
