# $Id: GSSAPI.pm 46852 2017-08-03 14:29:05Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/GSSAPI.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::GSSAPI;

use GSSAPI;

use Clarity -self;

field cfg;

sub checked() {
	my ($name, $status) = @_;
	return if $status;
	return unless defined $status;
	my $generic = $status->generic_message;
	my $specific = $status->specific_message;
	# controlled detonation:
	local $@;
	eval { undef $status; undef };
	die "[$name] $generic: $specific\n";
}

field principal => sub { shift->cfg->kerberos_principal };

const initiator_credentials => sub {
	my $self = shift;

	my $scred;
	checked(gss_acquire_cred => GSSAPI::Cred::acquire_cred($self->principal, GSS_C_INDEFINITE, GSS_C_NO_OID_SET, GSS_C_ACCEPT, $scred, undef, undef));
	return $scred;
};

sub authenticate {
	my $blob = shift;

	my $context = new GSSAPI::Context;
	my ($gss_client_name, $tname);
	my ($uid, $org) = eval {
		checked(gss_accept_sec_context => $context->accept($self->initiator_credentials, $blob, GSS_C_NO_CHANNEL_BINDINGS, $gss_client_name, undef, undef, undef, undef, undef));
		checked(gss_client_name_display => $gss_client_name->display($tname));
		return split('@', $tname, 2);
	};
	my $err = $@;

	# controlled detonation:
	local $@;
	eval { undef $tname; undef };
	eval { undef $gss_client_name; undef };
	eval { undef $context; undef };

	die $err if $err;

	return $org, $uid;
}
