# $Id: Document.pm 42155 2014-09-05 09:24:21Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Person/Put/Document.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Person::Put::Document;

use UvT::Kiki::WS::Person::Document -self;

sub build {
	my $req = $self->req;
	my $json = $self->json;
	my $notes = $req->notes;
	my $update = $notes->{update}->[0];
	my $previous = $req->old_person;
	if($update eq 'ok') {
		$json->{previous} = $previous if $previous;
		$json->{person} = $req->new_person;
	} else {
		$json->{person} = $previous if $previous;
	}
	$json->{notes} = $notes;
}

sub serialize {
	my $res = super;
	my $update = $self->req->notes->{update}->[0];
	$res->status(422)
		if $update eq 'error';
	return $res;
}
