use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::ACL::Request;

use UvT::Kiki::ACL::Document;

use UvT::Kiki::UI::Request -self;

sub nonce {
	return $self->is_robot || super;
}

sub login {
	return $self->remote_user || super;
}

sub authorized {
	if(my $uid = $self->remote_user) {
		my $cfg = $self->cfg;
		return exists $cfg->allowed_robots->{$uid}
			|| exists $cfg->allowed_users->{$uid};
	}
}

sub is_robot {
	my $uid = $self->remote_user;
	return defined $uid && exists $self->cfg->allowed_robots->{$uid};
}
