# $Id: Request.pm 47634 2018-06-26 13:03:40Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Alias/Post/Request.pm $

use re '/aa';

package UvT::Kiki::WS::Alias::Post::Request;

use JSON;

use UvT::Kiki::WS::Alias::Request -self;

my %interestingness = (
	changed => -1,
	unchanged => -2,
);
sub mostinteresting() {
	my ($a, $b) = @_;
	my $av = $interestingness{$a} // 0;
	my $bv = $interestingness{$b} // 0;
	return $bv > $av ? $b : $a;
}

field notes => {destinations => []};

field request_data => sub {
	my $self = shift;
	my $type = $self->content_type;
	die "Unsupported request content type '$type' (expected application/json)\n"
		if $type ne 'application/json';
	return decode_json($self->request_body->bodyhandle->as_string);
};

field new_alias => sub {
	my $self = shift;
	my $alias = super;
	my $notes = $self->notes;

	if($self->nonce) {
		my $data = $self->request_data;

		if($alias->type eq 'person') {
			$notes->{update} = [error => 'person'];
			return $alias;
		}

		my @destinations = map { trim($_) } @{$data->{destinations}};

		my $address = trim($data->{address});
		my ($localpart, $domain) = $address =~ /^(.*)@([^@]*)\z/;
		if(defined $domain) {
			$localpart = trim($localpart);
			$domain = trim($domain);
			my $localpartnote = $alias->update_localpart($localpart);
			my $domainnote = $alias->update_domain($domain);
			if($localpartnote->[0] eq 'error') {
				$notes->{address} = $localpartnote;
			} elsif($domainnote->[0] eq 'error') {
				$notes->{address} = $domainnote;
			} elsif($alias->unique) {
				$notes->{address} = [ok => mostinteresting($localpartnote->[1], $domainnote->[1]),
					$localpartnote->[2] . '@' . $domainnote->[2]];
			} else {
				$notes->{address} = [error => 'address-exists'];
			}
		} else {
			$notes->{address} = [error => 'invalid-localpart'];
		}
		$notes->{addressbook} = $alias->update_addressbook($data->{addressbook});
		$notes->{destinations} = $alias->update_destinations(\@destinations);

		if(grep { $_->[0] eq 'error' } $notes->{address}, $notes->{addressbook}, @{$notes->{destinations}}) {
			$notes->{update} = ['error'];
		} else {
			my $what = $self->is_robot ? "Robot" : "User";
			my $who = $self->login;
			my $new = $alias->toString;
			if(my $original = $alias->original) {
				my $address = $original->full;
				my $old = $original->toString;
				my $text = "$what $who updated alias:\n\told: $old\n\tnew: $new\n";
				warn $text;
				$self->mailtje("[kiki] $who updated $address", $alias->diff);
			} else {
				my $address = $alias->full;
				my $text = "$what $who created alias:\n\tnew: $new\n";
				warn $text;
				$self->mailtje("[kiki] $who created $address", $alias->diff);
			}

			$alias->store;
			$self->activate;
			$notes->{update} = [ok => 'stored'];
		}
	} else {
		$notes->{update} = [error => 'session'];
	}

	return $alias;
};
