# $Id: Document.pm 47634 2018-06-26 13:03:40Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Document.pm $

use re '/aa';

package UvT::Kiki::WS::Document;

use JSON;

use Xyzzy::Document -self;

stub xml;

field json => {};

sub build {
	# add nonce etc.
}

use Scalar::Util qw(reftype blessed);

sub ghetto_json() {
	my $val = shift;
	if(my $class = blessed($val)) {
		return "$val" if $class =~ /^JSON::(?:PP|XS)::Boolean\z/;
		my $rv = eval { ghetto_json($val->TO_JSON) };
		die "TO_JSON: $class: $@" if $@;
		return $rv;
	}
	my $type = reftype($val);
	if(defined $type) {
		if($type eq 'HASH') {
			my %rv;
			while(my ($k, $v) = each(%$val)) {
				$rv{$k} = eval { ghetto_json($v) };
				die "HASH: $k: $@" if $@;
			}
			return \%rv;
		} elsif($type eq 'ARRAY') {
			my @rv;
			my $i = 0;
			foreach my $v (@$val) {
				push @rv, eval { ghetto_json($v) };
				die "ARRAY: $i: $@" if $@;
				$i++;
			}
			return \@rv;
		} else {
			die "unknown type '$type'\n";
		}
	} else {
		return $val;
	}
}

sub serialize {
#	ghetto_json($self->json);
	our $encoder //= JSON->new->utf8->allow_blessed->convert_blessed;
	return new Xyzzy::Response(mimetype => 'application/json', content => $encoder->encode($self->json));
}
