use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::ACL::Request;

use UvT::Kiki::UI::Request -self;

field crypto => sub { shift->cfg->crypto };

field allowed_users => sub { shift->cfg->allowed_users };
field allowed_robots => sub { shift->cfg->allowed_robots };

field login => sub { shift->remote_user || die "REMOTE_USER not set\n" };

field session_data => sub {
	my $self = shift;
	return 's'.$self->remote_addr."\0".$self->login;
};

field session => sub {
	my $self = shift;
	my $cur_session = $self->cur_session;
	return $cur_session if $cur_session;
	my (undef, undef, $token) = $self->crypto->create_token($self->session_data);
	return $token;
};

field cur_session => sub {
	my $self = shift;
	my $token = $self->cookie('session');
	return eval { $self->crypto->check_token($self->session_data, $token); $token };
};

field authorized => sub {
	my $self = shift;
	my $uid = $self->login;
	return exists $self->allowed_robots->{$uid}
		|| exists $self->allowed_users->{$uid}
};

field is_robot => sub {
	my $self = shift;
	return exists $self->allowed_robots->{$self->login};
};

param nonce => sub {
	my $self = shift;
	$_ = $self->is_robot
		|| eval { $self->crypto->check_token('n'.$self->session, $_, $self->cfg->request_timeout); 1 };
};

sub create_nonce {
	my (undef, undef, $token) = $self->crypto->create_token('n'.$self->session);
	return $token;
}
