#! /usr/bin/env perl

# $Id: Build.PL 48568 2019-12-12 16:29:27Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/Build.PL $

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
	# create the MANIFEST file on the fly
	open my $fh, '>', 'MANIFEST' or die "open(MANIFEST): $!\n";
	find({wanted => sub { print $fh "$_\n" or die "write(MANIFEST): $!\n" if -f }, no_chdir => 1, follow => 0}, 'lib');
	close $fh or die "close(MANIFEST): $!\n";
};

my ($debian_package, $debian_version) = do {
	open my $fh, '<', 'debian/changelog' or die "open(debian/changelog): $!\n";
	<$fh> =~ /(\S+) \(([^\)~\s]+)[\)~]/
};

my $build = new Module::Build(
	module_name => 'UvT::Kiki',
	dist_name => $debian_package,
	dist_version => $debian_version,
	dist_abstract => 'Manage mailaliases',
	dist_author => 'Wessel Dankers <wsl@uvt.nl>',
	license => 'perl',
	create_makefile_pl => 'small',
	script_files => [],
);
$build->create_build_script;
