# $Id: Database.pm 37427 2012-07-13 15:06:59Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/Database.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::Database;

use UvT::Kiki::Database::Request;
use Net::DNS::Resolver;

use Xyzzy::Handler -self;

field dns => sub { new Net::DNS::Resolver };

sub handle {
	local $SIG{__DIE__} = sub { my $krak = shift; die $krak if ref $krak || $krak =~ /\n.*\n/; local $Carp::CarpLevel = 2; confess($krak) };
	my $req = new UvT::Kiki::Database::Request(ctx => shift, cfg => $self);
	return super($req);
}
