-- $Id: basics.sql 51832 2024-11-29 16:02:27Z wsl $
-- $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/doc/basics.sql $

\encoding UTF8

SET client_min_messages TO WARNING;

BEGIN;

DO $$
DECLARE
    r1 BIGINT;
    r2 BIGINT;
BEGIN
    INSERT INTO domainnames (name, domain) VALUES ('tilburguniversity.edu', create_domain('uvt.nl'));
    PERFORM create_domain('tias.edu');

    PERFORM create_person(100001, 'pietje@mailbox.uvt.nl');
    PERFORM create_person(100002, NULL);

    PERFORM create_personal_alias(100001, 'P.Ietje@uvt.nl');
    PERFORM set_canonical_alias(100001, 'P.Ietje@uvt.nl');
    PERFORM create_personal_alias(100001, 'pietje@uvt.nl');

    PERFORM create_personal_alias(100002, 'M.Arietje@uvt.nl');
    PERFORM set_canonical_alias(100002, 'M.Arietje@uvt.nl');
    PERFORM create_personal_alias(100002, 'marietje@uvt.nl');

    r1 := create_alias('koffie@uvt.nl', TRUE);
    PERFORM create_destination(r1, 'pietje@uvt.nl');

    r2 := create_alias('thee@uvt.nl', TRUE);
    PERFORM create_destination(r2, 'marietje@uvt.nl');

    -- Intentionally create a loop:
    PERFORM create_destination(r1, 'thee@uvt.nl');
    PERFORM create_destination(r2, 'koffie@uvt.nl');
END $$;

COMMIT;
