# $Id: Tokens.pm 51095 2023-10-27 14:39:16Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/pwdmodifier-pg/libpwdmodifier/lib/UvT/PwdModifier/Tokens.pm $

use strict;
use warnings FATAL => 'all';

package UvT::PwdModifier::Tokens;
use Carp;

use Spiffy -Base;

use Crypt::OpenSSL::Random;
use XML::LibXML;

field 'dir', -init => 'die "no token directory configured\n"';

sub random_bytes() {
	die "Insufficient entropy\n"
		unless Crypt::OpenSSL::Random::random_status;
	return Crypt::OpenSSL::Random::random_bytes(@_);
}

sub random_hex() {
	my $hex = unpack('H*', random_bytes(@_));
	$hex =~ tr/a-z/A-Z/;
	return $hex;
}

sub createToken {
	my $content = shift;
	my $doc = new XML::LibXML::Document('1.0', 'UTF-8');
	my $root = $doc->createElement('token');
	$doc->setDocumentElement($root);
	while(my ($key, $val) = each(%$content)) {
		$root->appendTextChild($key, $val);
	}
	my $dir = $self->dir;
	my $name = uc(random_hex(32));

	eval { $doc->toFile("$dir/tmp/$name", 1) };
	die "$dir/tmp/$name: $@" if $@;

	rename("$dir/tmp/$name", "$dir/new/$name")
		or die "$dir/new/$name: $!";

	return $name;
}

sub checkToken {
	my $name = shift;
	my $dir = $self->dir;

	$name = uc($name);
	return unless $name =~ /^[A-F0-9]{64}\z/;
	return unless -f "$dir/new/$name";

	my $parser = new XML::LibXML;
	$parser->pedantic_parser(1);
	$parser->validation(0);
	$parser->load_ext_dtd(0);
	$parser->expand_entities(0);
	$parser->keep_blanks(0);
	$parser->line_numbers(1);

	my $doc = $parser->parse_file("$dir/new/$name");

	my %res;
	my $root = $doc->documentElement;
	foreach my $node ($root->childNodes) {
		my $name = $node->nodeName;
		next unless $name;
		die "node '$name' must be unique"
			if exists $res{$name};
		$res{$name} = $node->textContent;
	}
	return \%res;
}

sub useToken {
	my $name = $_[0];
	my $res = $self->checkToken(@_)
		or return;

	my $dir = $self->dir;
	rename("$dir/new/$name", "$dir/cur/$name")
		or die "$dir/cur/$name: $!";

	return $res;
}

#
#=head1 lol
#
#my $tokending = new UvT::PwdModifier::Tokens(dir => '/var/lib/whatever/tokens');
#
#my $token = $tokending->createToken({foo => 3, bar => 17});
#
#print Dumper($tokending->useToken($token));
