# $Id: Config.pm 42262 2014-09-18 15:18:19Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/LDAP/Config.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::LDAP::Config;

use Xyzzy::LDAP;
use Xyzzy::LDAP::Config -self;

field ldap_expiry_conditions => [];
field ldap_expiry_attributes => {};

sub set_ldapexpiryattributes {
	my %attrs;
	my @conditions = split(' ', shift // '');
	foreach(@_) {
		next unless defined;
		my ($k, $v, $e) = split;
		next unless defined $k;
		die "found extraneous data '$e'\n"
			if defined $e;
		$attrs{$k} = $v // $k;
	}
	$self->ldap_expiry_conditions(@conditions ? \@conditions : [keys %attrs]);
	$self->ldap_expiry_attributes(\%attrs);
}
