# $Id: Request.pm 39279 2013-04-22 14:14:52Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Request;

use Aselect::URL qw(normalize_url valid_http_url);

use Aselect::Request -self;

sub uid {
	my $session = $self->cur_session;
	return $session && $session->uid;
}

field new_session => sub {
	my $self = shift;
	return $self->logout_ok
		? $self->create_session
		: $self->SUPER::new_session;
};

sub logout_ok {
	return $self->uid && ($self->effective_warn eq 'false' || $self->nonce);
}

sub confirmation_needed {
	return $self->uid && $self->effective_warn eq 'true' && !$self->nonce;
}

param service => sub {
	return unless defined;

	my $self = shift;
	my $cfg = $self->cfg;

	$_ = normalize_url($_);
	die $self->errorpage('service')
        unless valid_http_url($_);

	my $re = $cfg->urlfilter;
	die $self->errorpage('service')
		unless $_ =~ $re;

	$re = $cfg->servicefilter;
	die $self->errorpage('service')
		unless $_ =~ $re;

	$_ = $self->apply_https_everywhere($_);
};

field effective_warn => sub {
	my $self = shift;
	return 'true' if $self->bool_param('warn');
	return $self->new_warn;
};

field back_url => sub {
	return scalar shift->service;
};
