# $Id: Request.pm 42268 2014-09-22 14:05:34Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Success/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Success::Request;

use Aselect::Util;

use Aselect::Request -self;

field new_session => sub {
	my $self = shift;
	my $uid = $self->uid;
	return super unless defined $uid;
	return super unless $self->effective_remember eq 'true';
	return $self->create_session($uid);
};

field credentials => sub {
	my $self = shift;
	my $requestor_id = $self->requestor_id or return undef;
	my $uid = $self->uid or return undef;
	return scalar $self->crypto->create_token('c', $requestor_id, $uid);
};

field ticket => sub {
	my $self = shift;
	my $service = $self->service or return undef;
	my $uid = $self->uid or return undef;
	my $renew = $self->renew;
	return scalar $self->crypto->create_cas_token('ST', $service, $uid, $renew // ());
};

field cred_url => sub {
	my $self = shift;
	if(my $rid = $self->rid) {
		my $credentials = $self->credentials or return undef;
		return aselect_url($self->requestor_url, {
			rid => $rid,
			'a-select-server' => $self->server_id,
			aselect_credentials => $credentials,
		});
	} elsif(my $service = $self->service) {
		my $ticket = $self->ticket or return undef;
		return aselect_url($service, {ticket => $ticket});
	} else {
		return $self->script_url . '/status';
	}
};

field expiration_warning => sub {
	my $self = shift;
	# Only bother the user when initially signing in
	return undef if $self->new_session eq $self->cur_session;
	my $exp = eval { $self->dir->expiration($self->uid) };
	warn $@ if $@;
	return $exp;
};

field redirect_ok => sub {
	my $self = shift;
	return ($self->effective_warn eq 'false' || $self->nonce)
		&& !$self->expiration_warning;
};
