#! /usr/bin/perl

# $Id: submit.pl 40845 2014-01-15 14:46:10Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/brebo/bin/submit.pl $

use strict;
use warnings FATAL => 'all';
use autodie;

use lib qw(lib);

use UvT::Brebo;
use Carp qw(confess cluck);
use CGI;
use IO::Pipe;

my $cgi = new CGI;

our %htmlentities = (
    '"' => '&quot;',
    "'" => '&apos;',
    '<' => '&lt;',
    '>' => '&gt;',
    '&' => '&amp;',
);

sub htmlencode {
    my $html = shift;

    $html =~ s/(["'<>&])/$htmlentities{$1}/ge;
    $html =~ s/([^ -~])/'&#'.ord($1).';'/ge;

    return $html;
}

sub internal_error {
	my $err = shift;
	print $cgi->header(-status => '500 Application error');
	print <<EOT;
<html><head>
<title>Er is een fout opgetreden</title>
</head><body>
<h1>Er is een fout opgetreden</h1>
<p>Er is een probleem met deze applicatie.
Probeer het later nog eens.
Blijft het probleem zich voordoen, neem dan contact op met <a href="mailto:lis-unix\@uvt.nl">UvT LIS Unix</a>.</p>
<p>Excuses voor het ongemak.</p>
</body></html>
EOT

	my $hostname = `hostname`;
	my $pipe = new IO::Pipe;
	$pipe->writer(qw(/usr/lib/sendmail -oi -t));
	$pipe->write(<<EOT);
From: Wonenbreburg upload app <devnull\@uvt.nl>
To: lis-unix\@uvt.nl
Subject: internal error

Er is iets misgegaan met de Wonenbreburg upload app op $hostname. Hier
volgt de foutmelding:

$err

Succes met oplossen.

-- 
De Wonenbreburg upload app
EOT
	exit(1);
}

sub stacktrace {
	local $_ = shift;
	if(/\n.*\n/) {
		die $_;
	} else {
		local $Carp::CarpLevel = 1;
		confess($_);
	}
}

my $src = '/var/lib/wmb';
my $dst = '/var/lib/wmb/stage/students.csv';

if(my $upload = $cgi->upload('file')) {
	eval {
		local $SIG{__DIE__} = \&stacktrace;
		my $fh = $upload->handle;
		my $to = new IO::File("$dst,new", '>')
			or die "open($dst,new): $!\n";
		while($fh->read(my $buf, 65536)) {
			$to->write($buf)
				or die "write($dst,new): $!\n";
		}
		$to->flush or die "write($dst,new): $!\n";
		$to->sync or die "fsync($dst,new): $!\n";
		$to->close or die "close($dst,new): $!\n";;
	};
	internal_error($@) if $@;
} else {
	my $err = htmlencode($@);
	print $cgi->header;
	print <<EOT;
<html><head>
<title>Er is geen bestand geselecteerd</title>
</head><body>
<h1>Er is geen bestand geselecteerd</h1>
<p>Druk op de back-knop van uw browser en selecteer een bestand.
Klik pas daarna op Upload.</p>
<p>Komt u er dan nog niet uit, neem dan contact op met <a href="mailto:lis-unix\@uvt.nl">UvT LIS Unix</a>.</p>
</body></html>
EOT
	exit(0);
}

my $brebo = new UvT::Brebo;

eval {
	local $SIG{__DIE__} = \&stacktrace;
	$brebo->read_vlansfile("$src/vlans");
	$brebo->read_subnetfile("$src/subnets");
	$brebo->read_statefile("$src/leases");
	$brebo->read_tpgidfile("$src/tpgids");
	$brebo->addfile("$src/local.csv");
};
internal_error($@) if $@;

eval {
	$brebo->addfile("$dst,new");
	$brebo->ensure_consistent;
};
if($@) {
	my $err = htmlencode($@);
	print $cgi->header;
	print <<EOT;
<html><head>
<title>Er is iets mis met het bestand</title>
</head><body>
<h1>Er is iets mis met het bestand</h1>
<p>Het bestand zoals het is aangeboden kan helaas niet worden verwerkt.
Hieronder vindt u een beschrijving van het probleem.
Probeert u het probleem eerst aan de hand van de onderstaande melding op te lossen.
Komt u er dan nog niet uit, neem dan contact op met <a href="mailto:lis-unix\@uvt.nl">UvT LIS Unix</a>.</p>
<pre>$err</pre>
</body></html>
EOT
	exit(0);
} else {
	eval { rename("$dst,new", $dst) };
	internal_error($@) if $@;
	print $cgi->header;
	print <<EOT;
<html><head>
<title>Het bestand is geaccepteerd</title>
</head><body>
<h1>Het bestand is geaccepteerd</h1>
<p>Het zal binnen enkele minuten worden verwerkt.</p>
</body></html>
EOT
	exit(0);
}
