/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    private int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        for (Descriptors.FieldDescriptor object : this.getDescriptorForType().getFields()) {
            if (!object.isRequired() || this.hasField(object)) continue;
            return false;
        }
        for (Map.Entry entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            if (fieldDescriptor.isRepeated()) {
                for (Message message : (List)entry.getValue()) {
                    if (message.isInitialized()) continue;
                    return false;
                }
                continue;
            }
            if (((Message)entry.getValue()).isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String toString() {
        return TextFormat.printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        boolean bl = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            if (bl && fieldDescriptor.isExtension() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !fieldDescriptor.isRepeated()) {
                codedOutputStream.writeMessageSetExtension(fieldDescriptor.getNumber(), (Message)object);
                continue;
            }
            FieldSet.writeField(fieldDescriptor, object, codedOutputStream);
        }
        UnknownFieldSet unknownFieldSet = this.getUnknownFields();
        if (bl) {
            unknownFieldSet.writeAsMessageSetTo(codedOutputStream);
        } else {
            unknownFieldSet.writeTo(codedOutputStream);
        }
    }

    @Override
    public int getSerializedSize() {
        int n = this.memoizedSize;
        if (n != -1) {
            return n;
        }
        n = 0;
        boolean bl = this.getDescriptorForType().getOptions().getMessageSetWireFormat();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            if (bl && fieldDescriptor.isExtension() && fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && !fieldDescriptor.isRepeated()) {
                n += CodedOutputStream.computeMessageSetExtensionSize(fieldDescriptor.getNumber(), (Message)object);
                continue;
            }
            n += FieldSet.computeFieldSize(fieldDescriptor, object);
        }
        UnknownFieldSet unknownFieldSet = this.getUnknownFields();
        n = bl ? (n += unknownFieldSet.getSerializedSizeAsMessageSet()) : (n += unknownFieldSet.getSerializedSize());
        this.memoizedSize = n;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        if (this.getDescriptorForType() != message.getDescriptorForType()) {
            return false;
        }
        return ((Object)this.getAllFields()).equals(message.getAllFields()) && this.getUnknownFields().equals(message.getUnknownFields());
    }

    @Override
    public int hashCode() {
        int n = 41;
        n = 19 * n + this.getDescriptorForType().hashCode();
        n = this.hashFields(n, this.getAllFields());
        n = 29 * n + this.getUnknownFields().hashCode();
        return n;
    }

    protected int hashFields(int n, Map<Descriptors.FieldDescriptor, Object> map) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            n = 37 * n + fieldDescriptor.getNumber();
            if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                n = 53 * n + object.hashCode();
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                List list = (List)object;
                n = 53 * n + AbstractMessage.hashEnumList(list);
                continue;
            }
            n = 53 * n + AbstractMessage.hashEnum((Internal.EnumLite)object);
        }
        return n;
    }

    protected static int hashLong(long l) {
        return (int)(l ^ l >>> 32);
    }

    protected static int hashBoolean(boolean bl) {
        return bl ? 1231 : 1237;
    }

    protected static int hashEnum(Internal.EnumLite enumLite) {
        return enumLite.getNumber();
    }

    protected static int hashEnumList(List<? extends Internal.EnumLite> list) {
        int n = 1;
        for (Internal.EnumLite enumLite : list) {
            n = 31 * n + AbstractMessage.hashEnum(enumLite);
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<BuilderType extends Builder>
    extends AbstractMessageLite.Builder<BuilderType>
    implements Message.Builder {
        @Override
        public abstract BuilderType clone();

        public BuilderType clear() {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
                this.clearField(entry.getKey());
            }
            return (BuilderType)this;
        }

        public BuilderType mergeFrom(Message message) {
            if (message.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
                if (fieldDescriptor.isRepeated()) {
                    for (Object e : (List)entry.getValue()) {
                        this.addRepeatedField(fieldDescriptor, e);
                    }
                    continue;
                }
                if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message message2 = (Message)this.getField(fieldDescriptor);
                    if (message2 == message2.getDefaultInstanceForType()) {
                        this.setField(fieldDescriptor, entry.getValue());
                        continue;
                    }
                    this.setField(fieldDescriptor, message2.newBuilderForType().mergeFrom(message2).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(fieldDescriptor, entry.getValue());
            }
            this.mergeUnknownFields(message.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream) throws IOException {
            return (BuilderType)this.mergeFrom(codedInputStream, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            UnknownFieldSet.Builder builder = UnknownFieldSet.newBuilder(this.getUnknownFields());
            while ((n = codedInputStream.readTag()) != 0 && Builder.mergeFieldFrom(codedInputStream, builder, extensionRegistryLite, this, n)) {
            }
            this.setUnknownFields(builder.build());
            return (BuilderType)this;
        }

        static boolean mergeFieldFrom(CodedInputStream codedInputStream, UnknownFieldSet.Builder builder, ExtensionRegistryLite extensionRegistryLite, Message.Builder builder2, int n) throws IOException {
            Descriptors.FieldDescriptor fieldDescriptor;
            Descriptors.Descriptor descriptor = builder2.getDescriptorForType();
            if (descriptor.getOptions().getMessageSetWireFormat() && n == WireFormat.MESSAGE_SET_ITEM_TAG) {
                Builder.mergeMessageSetExtensionFromCodedStream(codedInputStream, builder, extensionRegistryLite, builder2);
                return true;
            }
            int n2 = WireFormat.getTagWireType(n);
            int n3 = WireFormat.getTagFieldNumber(n);
            Message message = null;
            if (descriptor.isExtensionNumber(n3)) {
                if (extensionRegistryLite instanceof ExtensionRegistry) {
                    ExtensionRegistry.ExtensionInfo extensionInfo = ((ExtensionRegistry)extensionRegistryLite).findExtensionByNumber(descriptor, n3);
                    if (extensionInfo == null) {
                        fieldDescriptor = null;
                    } else {
                        fieldDescriptor = extensionInfo.descriptor;
                        message = extensionInfo.defaultInstance;
                        if (message == null && fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                            throw new IllegalStateException("Message-typed extension lacked default instance: " + fieldDescriptor.getFullName());
                        }
                    }
                } else {
                    fieldDescriptor = null;
                }
            } else {
                fieldDescriptor = descriptor.findFieldByNumber(n3);
            }
            boolean bl = false;
            boolean bl2 = false;
            if (fieldDescriptor == null) {
                bl = true;
            } else if (n2 == FieldSet.getWireFormatForFieldType(fieldDescriptor.getLiteType(), false)) {
                bl2 = false;
            } else if (fieldDescriptor.isPackable() && n2 == FieldSet.getWireFormatForFieldType(fieldDescriptor.getLiteType(), true)) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (bl) {
                return builder.mergeFieldFrom(n, codedInputStream);
            }
            if (bl2) {
                int n4 = codedInputStream.readRawVarint32();
                int n5 = codedInputStream.pushLimit(n4);
                if (fieldDescriptor.getLiteType() == WireFormat.FieldType.ENUM) {
                    while (codedInputStream.getBytesUntilLimit() > 0) {
                        int n6 = codedInputStream.readEnum();
                        Descriptors.EnumValueDescriptor enumValueDescriptor = fieldDescriptor.getEnumType().findValueByNumber(n6);
                        if (enumValueDescriptor == null) {
                            return true;
                        }
                        builder2.addRepeatedField(fieldDescriptor, enumValueDescriptor);
                    }
                } else {
                    while (codedInputStream.getBytesUntilLimit() > 0) {
                        Object object = FieldSet.readPrimitiveField(codedInputStream, fieldDescriptor.getLiteType());
                        builder2.addRepeatedField(fieldDescriptor, object);
                    }
                }
                codedInputStream.popLimit(n5);
            } else {
                Object object;
                switch (fieldDescriptor.getType()) {
                    case GROUP: {
                        Message.Builder builder3 = message != null ? message.newBuilderForType() : builder2.newBuilderForField(fieldDescriptor);
                        if (!fieldDescriptor.isRepeated()) {
                            builder3.mergeFrom((Message)builder2.getField(fieldDescriptor));
                        }
                        codedInputStream.readGroup(fieldDescriptor.getNumber(), builder3, extensionRegistryLite);
                        object = builder3.build();
                        break;
                    }
                    case MESSAGE: {
                        Message.Builder builder4 = message != null ? message.newBuilderForType() : builder2.newBuilderForField(fieldDescriptor);
                        if (!fieldDescriptor.isRepeated()) {
                            builder4.mergeFrom((Message)builder2.getField(fieldDescriptor));
                        }
                        codedInputStream.readMessage(builder4, extensionRegistryLite);
                        object = builder4.build();
                        break;
                    }
                    case ENUM: {
                        int n7 = codedInputStream.readEnum();
                        object = fieldDescriptor.getEnumType().findValueByNumber(n7);
                        if (object != null) break;
                        builder.mergeVarintField(n3, n7);
                        return true;
                    }
                    default: {
                        object = FieldSet.readPrimitiveField(codedInputStream, fieldDescriptor.getLiteType());
                    }
                }
                if (fieldDescriptor.isRepeated()) {
                    builder2.addRepeatedField(fieldDescriptor, object);
                } else {
                    builder2.setField(fieldDescriptor, object);
                }
            }
            return true;
        }

        private static void mergeMessageSetExtensionFromCodedStream(CodedInputStream codedInputStream, UnknownFieldSet.Builder builder, ExtensionRegistryLite extensionRegistryLite, Message.Builder builder2) throws IOException {
            int n;
            Descriptors.Descriptor descriptor = builder2.getDescriptorForType();
            int n2 = 0;
            ByteString byteString = null;
            Message.Builder builder3 = null;
            Descriptors.FieldDescriptor fieldDescriptor = null;
            while ((n = codedInputStream.readTag()) != 0) {
                if (n == WireFormat.MESSAGE_SET_TYPE_ID_TAG) {
                    n2 = codedInputStream.readUInt32();
                    if (n2 == 0) continue;
                    ExtensionRegistry.ExtensionInfo extensionInfo = extensionRegistryLite instanceof ExtensionRegistry ? ((ExtensionRegistry)extensionRegistryLite).findExtensionByNumber(descriptor, n2) : null;
                    if (extensionInfo != null) {
                        fieldDescriptor = extensionInfo.descriptor;
                        builder3 = extensionInfo.defaultInstance.newBuilderForType();
                        Message message = (Message)builder2.getField(fieldDescriptor);
                        if (message != null) {
                            builder3.mergeFrom(message);
                        }
                        if (byteString == null) continue;
                        builder3.mergeFrom(CodedInputStream.newInstance(byteString.newInput()));
                        byteString = null;
                        continue;
                    }
                    if (byteString == null) continue;
                    builder.mergeField(n2, UnknownFieldSet.Field.newBuilder().addLengthDelimited(byteString).build());
                    byteString = null;
                    continue;
                }
                if (n == WireFormat.MESSAGE_SET_MESSAGE_TAG) {
                    if (n2 == 0) {
                        byteString = codedInputStream.readBytes();
                        continue;
                    }
                    if (builder3 == null) {
                        builder.mergeField(n2, UnknownFieldSet.Field.newBuilder().addLengthDelimited(codedInputStream.readBytes()).build());
                        continue;
                    }
                    codedInputStream.readMessage(builder3, extensionRegistryLite);
                    continue;
                }
                if (codedInputStream.skipField(n)) continue;
                break;
            }
            codedInputStream.checkLastTagWas(WireFormat.MESSAGE_SET_ITEM_END_TAG);
            if (builder3 != null) {
                builder2.setField(fieldDescriptor, builder3.build());
            }
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFieldSet).build());
            return (BuilderType)this;
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message) {
            return new UninitializedMessageException(Builder.findMissingFields(message));
        }

        private static List<String> findMissingFields(Message message) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Builder.findMissingFields(message, "", arrayList);
            return arrayList;
        }

        private static void findMissingFields(Message message, String string, List<String> list) {
            for (Descriptors.FieldDescriptor object : message.getDescriptorForType().getFields()) {
                if (!object.isRequired() || message.hasField(object)) continue;
                list.add(string + object.getName());
            }
            for (Map.Entry entry : message.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
                Object v = entry.getValue();
                if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
                if (fieldDescriptor.isRepeated()) {
                    int n = 0;
                    for (Object e : (List)v) {
                        Builder.findMissingFields((Message)e, Builder.subMessagePrefix(string, fieldDescriptor, n++), list);
                    }
                    continue;
                }
                if (!message.hasField(fieldDescriptor)) continue;
                Builder.findMissingFields((Message)v, Builder.subMessagePrefix(string, fieldDescriptor, -1), list);
            }
        }

        private static String subMessagePrefix(String string, Descriptors.FieldDescriptor fieldDescriptor, int n) {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (fieldDescriptor.isExtension()) {
                stringBuilder.append('(').append(fieldDescriptor.getFullName()).append(')');
            } else {
                stringBuilder.append(fieldDescriptor.getName());
            }
            if (n != -1) {
                stringBuilder.append('[').append(n).append(']');
            }
            stringBuilder.append('.');
            return stringBuilder.toString();
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byteString));
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byteString, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n, n2));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n, n2, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(inputStream));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(inputStream, extensionRegistryLite));
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) throws IOException {
            return super.mergeDelimitedFrom(inputStream);
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return super.mergeDelimitedFrom(inputStream, extensionRegistryLite);
        }
    }
}

