/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import java.io.UnsupportedEncodingException;

public class Internal {
    public static String stringDefaultValue(String string) {
        try {
            return new String(string.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Java VM does not support a standard character set.", unsupportedEncodingException);
        }
    }

    public static ByteString bytesDefaultValue(String string) {
        try {
            return ByteString.copyFrom(string.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Java VM does not support a standard character set.", unsupportedEncodingException);
        }
    }

    public static boolean isValidUtf8(ByteString byteString) {
        int n = 0;
        int n2 = byteString.size();
        while (n < n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            if ((n6 = byteString.byteAt(n++) & 0xFF) < 128) continue;
            if (n6 < 194 || n6 > 244) {
                return false;
            }
            if (n >= n2) {
                return false;
            }
            if ((n5 = byteString.byteAt(n++) & 0xFF) < 128 || n5 > 191) {
                return false;
            }
            if (n6 <= 223) continue;
            if (n >= n2) {
                return false;
            }
            if ((n4 = byteString.byteAt(n++) & 0xFF) < 128 || n4 > 191) {
                return false;
            }
            if (n6 <= 239) {
                if ((n6 != 224 || n5 >= 160) && (n6 != 237 || n5 <= 159)) continue;
                return false;
            }
            if (n >= n2) {
                return false;
            }
            if ((n3 = byteString.byteAt(n++) & 0xFF) < 128 || n3 > 191) {
                return false;
            }
            if ((n6 != 240 || n5 >= 144) && (n6 != 244 || n5 <= 143)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EnumLiteMap<T extends EnumLite> {
        public T findValueByNumber(int var1);
    }

    public static interface EnumLite {
        public int getNumber();
    }
}

