<?php

/**
 * @file
 * Process theme data.
 *
 * Use this file to run your theme specific implimentations of theme functions,
 * such preprocess, process, alters, and theme function overrides.
 *
 * Preprocess and process functions are used to modify or create variables for
 * templates and theme functions. They are a common theming tool in Drupal, often
 * used as an alternative to directly editing or adding code to templates. Its
 * worth spending some time to learn more about these functions - they are a
 * powerful way to easily modify the output of any template variable.
 *
 * Preprocess and Process Functions SEE: http://drupal.org/node/254940#variables-processor
 * 1. Rename each function and instance of "sitebuilder_uvt" to match
 *    your subthemes name, e.g. if your theme name is "footheme" then the function
 *    name will be "footheme_preprocess_hook". Tip - you can search/replace
 *    on "sitebuilder_uvt".
 * 2. Uncomment the required function to use.
 */


/**
 * Preprocess variables for the html template.
 */
/* -- Delete this line to enable.
function sitebuilder_uvt_preprocess_html(&$vars) {
  global $theme_key;

  // Two examples of adding custom classes to the body.

  // Add a body class for the active theme name.
  // $vars['classes_array'][] = drupal_html_class($theme_key);

  // Browser/platform sniff - adds body classes such as ipad, webkit, chrome etc.
  // $vars['classes_array'][] = css_browser_selector();

}
// */


/**
 * Process variables for the html template.
 */
/* -- Delete this line if you want to use this function
function sitebuilder_uvt_process_html(&$vars) {
}
// */


/**
 * Override or insert variables for the page templates.
 */
function sitebuilder_uvt_preprocess_page(&$vars) {
  // Provide a variable to all templates to test for a mobile context, this
  // requires the Browscap module and returns TRUE or FALSE.
}


/**
 * Override or insert variables into the node templates.
 */
/* -- Delete this line if you want to use these functions
function sitebuilder_uvt_preprocess_node(&$vars) {
}
function sitebuilder_uvt_process_node(&$vars) {
}
// */


/**
 * Override or insert variables into the comment templates.
 */
/* -- Delete this line if you want to use these functions
function sitebuilder_uvt_preprocess_comment(&$vars) {
}
function sitebuilder_uvt_process_comment(&$vars) {
}
// */


/**
 * Override or insert variables into the block templates.
 */
/* -- Delete this line if you want to use these functions
function sitebuilder_uvt_preprocess_block(&$vars) {
}
function sitebuilder_uvt_process_block(&$vars) {
}
// */

/**
 * Shows listing of asset metadata.
 *
 * The theme used to generate a listing of metadata in the views using
 * mediamosa_ck_views_field_text_metadata. Slightly modified from the original:
 * no showing of empty rows.
 *
 * @param array $variables
 *   Data used for the theme.
 */
function sitebuilder_uvt_mediamosa_ck_views_theme_asset_metadata($variables) {
  $rows = array();

  ksort($variables['metadata']);

  foreach ($variables['metadata'] as $name => $value) {
    $name = drupal_ucfirst(str_replace('_', ' ', $name));
    if (empty($value)) {
      $rows[] = array('class' => array('empty'), 'data' => array('name' => t($name), 'value' => ''));
    }
    else {
      $rows[] = array('data' => array('name' => t($name), 'value' => nl2br(check_plain(t($value)))));
    }
  }
  if (empty($rows)) {
    $rows[] = array('-', '');
  }

  return theme('table', array('rows' => $rows));
}

/**
 * Returns HTML for the Powered by MediaMosa.
 *
 * @ingroup themeable
 */
function sitebuilder_uvt_mediamosa_sb_powered_by_mediamosa() {
  $image = theme('image', array(
             'path' => drupal_get_path('module', 'mediamosa_sb') . '/images/logo32.png',
             'alt' => t('Powered by MediaMosa'),
             'title' => t('Powered by MediaMosa'),
           )
  );
  $output = '<div class="mediamosa-logo-small">';
  $output .= l($image , 'http://mediamosa.org', array('attributes' => array(), 'html' => TRUE));
  $output .= '</div>';
  return $output;
}


/**
 * Implements template_process_html().
 *
 * Override or insert variables into the page template for HTML output.
 */
function sitebuilder_uvt_process_html(&$variables) {
  // Hook into color.module.
  if (module_exists('color')) {
    _color_html_alter($variables);
  }
}

/**
 * Implements template_process_page().
 */
function sitebuilder_uvt_process_page(&$variables, $hook) {
  // Hook into color.module.
  if (module_exists('color')) {
    _color_page_alter($variables);
  }
}

/**
 * Create themed owner field.
 */
function sitebuilder_uvt_theme_mediamosa_ck_views_theme_owner($variables) {
  if (module_exists('surfconext')) {
    $u = user_load($variables['uid']);
    if (isset($u->display_name) && isset($u->display_name['und'][0]['value'])) {
      return $u->display_name['und'][0]['value'];
    }
    else {
      return '-';
    }
  }
  theme_mediamosa_ck_views_theme_owner($variables);
}
