/* $Id: freebind.c 42664 2014-12-08 14:17:23Z wsl $ */
/* $URL: https://svn.uvt.nl/its-id/trunk/sources/freebind/freebind.c $ */

#define _GNU_SOURCE

#include <unistd.h>
#include <dlfcn.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#if !defined(__SOCKADDR_ALLTYPES) && !defined(__CONST_SOCKADDR_ARG)
#define __CONST_SOCKADDR_ARG const struct sockaddr
#endif

static int (*libc_bind)(int, __CONST_SOCKADDR_ARG, socklen_t) = NULL;

extern void libfreebind_init(void);

__attribute__((constructor))
void libfreebind_init(void) {
	const char *error;
	dlerror();
	libc_bind = dlsym(RTLD_NEXT, "bind");
	error = dlerror();
	if(error)
		(void)write(STDERR_FILENO, error, strlen(error));
}

int bind(int fd, __CONST_SOCKADDR_ARG sa, socklen_t sa_len) {
	int toggle = 1;
	if(libc_bind) {
		if(setsockopt(fd, IPPROTO_IP, IP_FREEBIND, &toggle, sizeof toggle) == -1 && errno != EOPNOTSUPP)
			return -1;

		return libc_bind(fd, sa, sa_len);
	}
	errno = ENOSYS;
	return -1;
}
