# $Id: Request.pm 37340 2012-07-02 17:27:19Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/UI/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package UvT::Kiki::UI::Request;

use UvT::Kiki::Request -self;

field lang => sub {
	my $self = shift;

	my @supported = @{$self->cfg->languages};
	return undef unless @supported;
	my %supported; @supported{@supported} = ();

	if(my $lang = $self->cookie('lang')) {
		foreach my $preferred (split(qr{\s*/\s*}, lc($lang))) {
			return $preferred if exists $supported{$preferred};
		}
	}

	my $h = lc($self->http('Accept-Language'));
	$h =~ s/\s//g;

	my $curlang = $supported[0];
	my $curlevel = 0;

	foreach my $q (split(',', $h)) {
		my $level = 1;
		my ($lang, @attrs) = split(';', $q);
		$lang =~ s/-.*//;
		next unless exists $supported{$lang};
		foreach my $a (@attrs) {
			my ($key, $val) = split('=', $a, 2);
			next unless $key eq 'q';
			next unless defined $val;
			next unless $val =~ /^\d+(?:\.\d+)?$/;
			$level = $val;
		}
		if($level > $curlevel) {
			$curlang = $lang;
			$curlevel = $level;
		}
	}

	return $curlang;
};
