# $Id: Document.pm 37653 2012-08-27 19:19:32Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/UI/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package UvT::Kiki::UI::Document;

use Xyzzy::Document::XHTML -self;

sub getStylesheet {
	my $lang = $self->req->lang
		or return super;
	my $file = shift;
	return super("$lang/$file", @_);
}

sub transform {
	return if $self->req->raw;
	return super;
}

sub build {
	my $name = $self->rootname;
	my $root = $self->createElement($name);
	$self->setDocumentElement($root);

	my $uid = $self->req->session; 
	$root->appendTextChild(uid => $uid)
		if defined $uid;

	$self->hook_next;

	eval { $self->transform($name) };
	warn $@ if $@;
}

sub response {
	my $res = super;

	# DOM/XSL system protects against XSS
	$res->setheader('X-XSS-Protection' => 0);

	# Don't try to second guess the content type
	$res->setheader('X-Content-Type-Options' => 'nosniff');

	# Protect against clickjacking
	$res->setheader('X-Frame-Options' => 'DENY');

	$res->mimetype('application/xml')
		if $self->req->raw;

	return $res;
}
