# $Id: Request.pm 37640 2012-08-25 19:37:44Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package UvT::Kiki::Request;

use Xyzzy::Util qw(parse_bool);

use Xyzzy::Request -self;

our @EXPORT_BASE = qw(bool_param trim);

sub bool_param(*) {
	my $name = shift;
	if(ref $name) {
		my $self = $name;
		$name = shift;
		my ($val) = $self->param($name)
			or return undef;
		return eval { parse_bool($val) } // 1;
	}
	my $package = caller;
	Clarity::Internals::field($package, $name, sub {
		my ($val) = shift->param($name)
			or return undef;
		return eval { parse_bool($val) } // 1;
	});
}

bool_param raw;

sub trim() {
	return map { scalar trim($_) } @_ if wantarray;
	local $_ = shift;
	if(defined) {
		s/\s+/ /g;
		s/^ //;
		s/ $//;
	}
	return $_;
}
