# $Id: Request.pm 37660 2012-08-28 09:49:55Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Alias/Post/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Alias::Post::Request;

use JSON;

use UvT::Kiki::WS::Alias::Request -self;

field notes => {name => '', domain => '', destinations => []};

field request_data => sub {
	my $self = shift;
	my $type = $self->content_type;
	die "Unsupported request content type '$type' (expected application/json)\n"
		if $type ne 'application/json';
	return decode_json($self->request_body->bodyhandle->as_string);
};

field new_alias => sub {
	my $self = shift;
	my $alias = super;

	if($self->nonce) {
		my $db = $self->db;
		my $address = $self->address;
		my $data = $self->request_data;
		my $notes = $self->notes;

		if($alias->type eq 'person') {
			$notes->{update} = [error => 'person'];
			return $alias;
		}

		my @destinations = map { trim($_) } @{$data->{destinations}};

		$notes->{name} = $alias->update_name(trim($data->{name}));
		$notes->{domain} = $alias->update_domain($data->{domain});
		$notes->{addressbook} = $alias->update_addressbook($data->{addressbook});
		$notes->{destinations} = $alias->update_destinations(\@destinations);

		if(grep { $_->[0] eq 'error' } $notes->{name}, $notes->{domain}, $notes->{addressbook}, @{$notes->{destinations}}) {
			$notes->{update} = ['error'];
		} else {
			if($alias->unique) {
				my $who = $self->login;
				my $new = $alias->toString;
				if(my $original = $alias->original) {
					my $name = $original->full;
					my $old = $alias->original->toString;
					my $text = "User $who updated alias:\n\told: $old\n\tnew: $new\n";
					warn $text;
					$self->mailtje("[kiki] $who updated $name", $text);
				} else {
					my $name = $alias->full;
					my $text = "User $who created alias:\n\tnew: $new\n";
					warn $text;
					$self->mailtje("[kiki] $who created $name", $text);
				}

				$alias->store;
				$self->activate;
				$notes->{update} = [ok => 'stored'];
			} else {
				$notes->{update} = [error => 'alias-exists'];
			}
		}
	} else {
		$self->notes({update => [error => 'session']});
	}

	return $alias;
};
