# $Id: Document.pm 37643 2012-08-26 19:26:17Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/UI/Export/Document.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::UI::Export::Document;

use Xyzzy::Document -self;

sub serialize {
	my $export = $self->req->export;
	my $file = join('', map {
			"$_: ".join(', ', @{$export->{$_}})."\n";
		} (sort keys %$export));
	my $res = new Xyzzy::Response(mimetype => 'text/plain', content => $file);
	$res->addheader('Content-Disposition' => 'attachment');
	return $res;
}
