/* kjq: jquery voor kiki
	Voorkom conflicten met de jquery-versie die door de rest van de website
	wordt gebruikt.
	Ontwikkeld op jquery-1.6 .
*/

var kjq = jQuery.noConflict(true);

$(document).ready(function() {
	/*
	 * Geef een waarschuwing als er nog ongesavete formulieren zijn.
	 */
	/* * disabled for debugging
	$(window).bind('beforeunload', function(){
		if ($('.changed').length > 0 ) {
			return '>>>>>Before You Go<<<<<<<< \n There is unsaved data!';
		}
	});
	*/


	/*
	 * maak een aantekening als een formulier wordt gewijzigd
	 */
	kjq('form :input').change(function() {
		SetChanged(this);
	});


	/*
	 * Opheffen bij reset-knop
	 */
	kjq('form').bind('reset', function() {
		UnsetChanged(this);
	});


	/*
	 * edit alias
	 */
	kjq('form.editAlias').bind('submit', function() {
		/* fixme: pas resetten als de data succesvol is opgeslagen */
		/* if validate == fail; then return false else this.submit()*/
		event.preventDefault();

		UnsetChanged(this);
	});
	

	/*
	 * extra destination veldje toevoegen aan een alias
         */
	$(".addDestinationButton").click(function() {
		AddDestination(this);
	});

	/*
	 * destination veldje(s) verwijderen van een alias
         */
	$(".delDestinationButton").click(function() {
		DelDestination(this);
	});

	/* huisstijlpolitiestijlvel ontwijken (werkt alleen nog in Chrome) */
	/*
	kjq('#contentBlocks').css('width', '100%');
	kjq('.extraWide').css('width', '95% !important');
	*/


	/* 
	 * Extra informatie & edit mogelijkheden inklappen.
	 * Alleen voor javascript-gebruikers (die het ook weer kunnen uitklappen).
	 * Anderen zien alles volledig uitgevouwen.
	 * De eerste entry blijft altijd uitgevouwen omdat de gebruiker deze
	 * waarschijnlijk wil bewerken. (postion :greaterThan 0)
	 */
	kjq('.expanded:gt(0)').css('display', 'none');


	/*
	 * tooltips
	 */
	kjq('.tooltip').tipsy();

	/*
	 * Save button uitschakelen tot er iets te saven is.
	 */ 
	kjq('.saveButton').attr('disabled','disabled');
	kjq('.resetButton').attr('disabled','disabled');
});



/* (un)fold de rij met de uitgebreide informatie over een alias */
function ToggleBox(target)
{	
        kjq('.'+target).slideToggle('fast'); 	
        kjq('.foldimg'+target).toggle();	// plaatje ook veranderen
}

/* 
 * (Un)check all checkboxes of class <target> depending on the state of #controller<target>
 */
function CheckAll(target)
{
	var newState = kjq("#controller"+target).is(':checked');
	kjq("."+target).each(function() { 
		this.checked = newState;
	}); 
}

/*
 * Markeer de verandere delen en actieveer de 'change' en 'reset'  buttons.
 */
function SetChanged(target)
{
	kjq(target).addClass('changed');
	var parent = kjq(target).parents('div.entry');
	parent.addClass('changed');
	parent.find('.saveButton').removeAttr('disabled');
	parent.find('.resetButton').removeAttr('disabled');
}

/*
 * Verwijder de markering weer
 */
function UnsetChanged(target)
{
	kjq(target).parents('div.entry').removeClass('changed');
	kjq(target).parents('div.entry').find('.changed').removeClass('changed');
	var parent = kjq(target).parents('div.entry');
	parent.removeClass('changed');
	parent.find('.changed').removeClass('changed');		
	parent.find('.saveButton').attr('disabled','disabled');
	parent.find('.resetButton').attr('disabled','disabled');
}

/*
 * Destination veldje toevoegen
 */
function AddDestination(target)
{
	var form = kjq(target).closest('form');
	var aliasId = form.find('.aliasId').val();
	var destinationList = form.find('.destinations');
	var aliasField = [
		'<li>',
		'	<input type="checkbox" name="destinationC" class="boxes' + aliasId + '" />',
		'	<input type="text" name="destinationT" value="" /> ',
		'</li>'
		].join('\n');
	destinationList.append(aliasField);
}

/*
 * Destination veldje leeg maken
 */
function DelDestination(target)
{
	var form = kjq(target).closest('form');
	//var checked = form.find('ul.destinations :checkbox:checked + :input[type="text"]').
	form.find('ul.destinations :checkbox:checked + :input[type="text"]').each( function() {
		this.value = '';
	});
	var checked = form.find('ul.destinations :checkbox:checked');
	form.find('ul.destinations :checkbox:checked').attr('checked', false);
}

