# $Id: Person.pm 37703 2012-08-30 12:05:54Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/Database/Person.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::Database::Person;

use UvT::Kiki::Database::Alias -self;

use constant type => 'person';
use constant addressbook => undef;

field anr;

field destinations => sub {
	my $self = shift;
	return [$self->db->mailbox_for_anr($self->anr)];
};

field names => sub {
	my $self = shift;
	return $self->db->names_for_anr($self->anr);
};

sub clone {
	my $clone = super;
	$clone->anr($self->anr);
	return $clone;
}

sub TO_JSON {
	my $res = super;
	$res->{anr} = sprintf('%06d', $self->anr);
	$res->{names} = $self->names
		if $self->names_isset;
	return $res;
}
