# $Id: Request.pm 37672 2012-08-29 07:40:45Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Alias/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Alias::Request;

use UvT::Kiki::WS::Request -self;

use Email::Sender::Simple qw(sendmail);
use Email::Simple;

sub mailtje {
	my ($subject, $body) = @_;

	my $cfg = $self->cfg;
	my $recipients = $cfg->notification_recipients;
	return unless @$recipients;
	my $sender = $cfg->notification_sender;

	my $mail = Email::Simple->create(
		header => [
			From => $sender,
			To => join(', ', @$recipients),
			Subject => $subject,
		],
		body => $body,
	 );

	eval { sendmail($mail) } or die $@->message;
}

field address => sub {
	my $self = shift;
	my (undef, $address) = @{$self->pairs};
	die "Malformed value '$address' for field 'address'\n"
		if defined $address && $address !~ /^[^@]+\@[^@]+$/;
	return $address;
};

field old_alias => sub { shift->new_alias->original };

field new_alias => sub {
	my $self = shift;
	my $address = $self->address;
	return $self->db->new_alias unless defined $address;
	my $alias = $self->db->fetch_alias($address);
	die "Unknown alias '$address'\n" unless defined $alias;
	return $alias;
};
