# $Id: Request.pm 37704 2012-08-30 12:06:31Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/kiki/lib/UvT/Kiki/WS/Search/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package UvT::Kiki::WS::Search::Request;

use UvT::Kiki::WS::Request -self;

field search_query => sub {
	return trim(shift->param('q'));
};

field results => sub {
	my $self = shift;

	my $db = $self->db;

	my $query = $self->search_query;

	return [] unless defined $query;

	my $res = $db->search_alias($query);

	foreach my $a (@$res) {
		$a->names;
		$a->destinations;
	}

	return $res;
};
