use utf8;
use strict;
use warnings FATAL => 'all';

package KUB;

use Xyzzy::CAS;
use Xyzzy::Crypto;
use Xyzzy::Directory;
use Xyzzy::Database;
use Xyzzy::First;

use KUB::Manage;
use KUB::Redirect;
use KUB::Resources;
use KUB::Notfound;
use KUB::Windshield;

use Xyzzy -self;
use Xyzzy::CAS::Config -mixin;
use Xyzzy::Crypto::Config -mixin;
use Xyzzy::Database::Config -mixin;

use KUB::Config -mixin;
use KUB::LDAP::Config -mixin;

sub handler {
	my $rsc = new KUB::Resources(cfg => $self);
	return new KUB::Windshield(cfg => $rsc,
		handler => new Xyzzy::Database(cfg => $rsc,
			handler => new Xyzzy::Directory(cfg => $rsc,
				handler => new Xyzzy::CAS(cfg => $rsc,
					handler => new KUB::Manage(cfg => $rsc),
				),
				fallback => new Xyzzy::CAS(cfg => $rsc,
					cas_snoop => 1, snoop => 1,
					handler => new KUB::Redirect(cfg => $rsc,
						fallback => new KUB::Notfound(cfg => $rsc),
					)
				)
			)
		)
	);
}
