use strict;
use warnings FATAL => 'all';
use utf8;

package KUB::Request;

use Xyzzy::Util qw(parse_bool);
use KUB::Request::Error;

use Xyzzy::Request -self;

field raw => sub {
	my ($raw) = shift->param('raw') 
		or return undef;
	return eval { parse_bool($raw) } // 1;
};

field lang => sub {
	my $self = shift;

	my @supported = @{$self->cfg->languages};
	return undef unless @supported;
	my %supported; @supported{@supported} = ();

	if(my $lang = $self->cookie('lang')) {
		foreach my $preferred (split(qr{\s*/\s*}, lc($lang))) {
			return $preferred if exists $supported{$preferred};
		}
	}

	my $h = lc($self->http('Accept-Language') // '');
	$h =~ s/\s//g;

	my $curlang = $supported[0];
	my $curlevel = 0;

	foreach my $q (split(',', $h)) {
		my $level = 1;
		my ($lang, @attrs) = split(';', $q);
		$lang =~ s/-.*//;
		next unless exists $supported{$lang};
		foreach my $a (@attrs) {
			my ($key, $val) = split('=', $a, 2);
			next unless $key eq 'q';
			next unless defined $val;
			next unless $val =~ /^\d+(?:\.\d+)?$/;
			$level = $val;
		}
		if($level > $curlevel) {
			$curlang = $lang;
			$curlevel = $level;
		}
	}

	return $curlang;
};

sub error {
	my ($type, $exc, %args) = @_;
	die $exc if UNIVERSAL::isa($exc, 'Xyzzy::Response');
	warn $exc if $exc;
	my $doc = new KUB::Request::Error(req => $self, type => $type, args => \%args);
	return $doc->response;
}
