# Deze module is afkomstig van LdapSearch, die vroeger een losse module was.
package SimpleLdapSearch;
use strict;
use warnings  FATAL=> 'all';

our @ISA=('Baseobject' );
use Net::LDAPS;
use Net::LDAP;

use Baseobject;
use Exporter;

use Data::Dumper;
$Data::Dumper::Indent=1;

sub new
{
  my $pkg=shift;
  my $self= bless (new Baseobject(@_),$pkg);

  # format for 'serverinfo':
  # ldaps://ldap.uvt.nl:636 ; o=Universiteit van Tilburg, c=NL

  $self->needs(
	       [ qw ( serverinfo) ]
	       ) ;

  $self->allows (
		  {
		    capath=>'/etc/ssl/certs' ,
		    dumpsearch=>0,
		    attrs=>0,
		  });
  $self->allows ( [ qw ( binddn bindpwd bindfilter msg encodefilter bound)]);

  $self->fields(@_);
  $self->checkneeds();
  return $self if ($self->error());

  $self->ldapinit();
  return $self;
}

sub ldapinit
{
  my $self=shift;
  my $host=$self->{fields}->{serverinfo};
  my $userinfo;
  my ($type,$port,$base);
  ($type,$host,$port)=split(/:/,$host);
  ($port,$base)=split(/\s*;\s*/, $port,2);
  $host=~ s{//}{};

  $self->debug ( "type: $type, port: $port, base: $base, host: $host");
  $self->{base}=$base;

  $self->debug( "Creating new ldap instance") ;
  if ($type eq 'ldaps' )
  {
    $self->{ldap}=Net::LDAPS->new(
		$host,
		'verify' => 'require',
		'capath' => $self->{fields}->{capath},
		'raw' => qr/(?i:^jpegPhoto|;binary)/,
		'port'=> => $port,
	);
  }
  elsif ($type eq 'ldap')
  {
    $self->{ldap}= Net::LDAP->new(
		$host,
		'port'=>$port,
		'raw' => qr/(?i:^jpegPhoto|;binary)/
	);
  }else
  {
    warn "Invalid url in serverinfo: \"$type\", should be ldaps:// or ldap://";
    $self->error('invalid_serverinfo');
  }

  unless ($self->{ldap})
  {
    warn "Could not connect to $type//$host:$port $@";
    $self->error("connect_failed" );
  }

  my $msg;
  if (exists ($self->{fields}->{bindpwd}))
  {
    unless (exists ($self->{fields}->{binddn}))
    {
      if (exists ($self->{fields}->{bindfilter}))
      {
	$msg=$self->search($self->{fields}->{bindfilter},1);
	my $entry=($msg->entries)[0];
	unless (defined($entry))
	{
	  $self->error("no hits for bindfilter: $self->{fields}->{bindfilter} ");
	  return;
	}

	$self->{fields}->{binddn}=$entry->dn();
      }
    }

    $msg=$self->{ldap}->bind(
			     $self->{fields}->{binddn},
			     password=>$self->{fields}->{bindpwd}
		   );
    if ($msg->code)
    {
      warn "error binding $self->{fields}->{binddn} on ldapserver: $type://$host",$msg->error();
      $self->error("bind failed ". $msg->error());
      $self->{fields}->{bound}=0;
    }
    else
    {
      $self->debug( "BIND SUCCESSFUL FOR: $self->{fields}->{binddn}") ;
      $self->{fields}->{bound}=1;
    }
  }
}
sub search
{
  my ($self,$filter,$savestate)=@_;
  $filter=encode($filter)  if ($self->{fields}->{encodefilter});

  warn "actual filter: $filter" if ($self->{fields}->{dumpsearch});

  my $msg=$self->{ldap}->
      search(base   => $self->{base},
	     filter => $filter,
	     );
  if ($msg->code)
  {
    $self->error("search failed: ",$msg->error(),
		    "\nfilter => $filter\n",
		    "base  => $self->{base}",
		    );
  }
  $self->{fields}->{msg}=$msg if (defined ($savestate) and $savestate);
  return $msg;
}

sub encode
{

#   http://www.cse.ohio-state.edu/cgi-bin/rfc/rfc2254.html
#
#   If a value should contain any of the following characters
#
#             Character       ASCII value
#             ---------------------------
#             *               0x2a
#             (               0x28
#             )               0x29
#             \               0x5c
#             NUL             0x00
#  #
#     the character must be encoded as the backslash '\' character (ASCII
#     0x5c) followed by the two hexadecimal digits representing the ASCII
#     value of the encoded character.

  my $str=shift;
  # comfort emacs ;(
#  map {$specialchars->{$_}=1 } split (//,'\()\*');

# Het simpelst is gewoon ALLES coderen, maar dat vinden mensenogen niet fijn.
# .. who cares?..
#  my $encoded='\\'.join('\\', map {sprintf ("%x",$_)} unpack('U*',$str));

#
# alternatief: codeer alleen de noneword characters,
# NB. blijf van de wildcard '*' af!
#
  my $res='';
  foreach my $char (split (//,$str))
  {
    if ($char =~ /\W/ and $char !~ /\*/)
    {
      $res.='\\'. sprintf ("%x",ord($char));
    }
    else
    {
      $res.=$char;
    }
  }

  return $res;
}
42;


=head1 NAME

LdapSearch - LdapSearch

=head1 SYNOPSIS
Performs basic simpel operations to query an ldap server.


=head1 DESCRIPTION

The module accepts the folowing parameters: (extract from source )

  $self->needs(
	       [ qw ( serverinfo) ]
	       ) ;

  $self->allows (
		  {
		    capath=>'/etc/ssl/certs' ,
		    dumpsearch=>0,
		  });
  $self->allows ( [ qw ( bindpwd binddn bindfilter msg encodefilter)]);

All parameters serve as input for the module, except 'msg' which
can be used by the calling program.

METHODS
 new

PARAMETERS

 serverinfo, string
  The format of the serverinfo is:
   protocol://ldapserver:port;base
  par example:
   ldaps://ldap.uvt.nl:636 ; o=Universiteit van Tilburg, c=NL

 capath, string
  Path to ca certificates.

 dumpsearch, boolean
  If true: Display each filter before an ldapsearch is performed

 bindpwd, string
  Bind with this password.
  Use the bindn if provided, otherwise find the bindn using the bindfilter
  If no bindpwd is provided, no bindattempt is made.

 bindn, string
  Bind to this dn.

 bindfilter, string
  Use this to fetch the binddn if not provided.

 encodefilter, boolean
  If true: encode special characters in the filter.

search()

PARAMETERS
  filter

RETURNS
  msg

encode()

PARAMETERS
  string

RETURNS
  encoded string



=head1 USAGE

  use LdapSearch;
  my $ldap=new LdapSearch(
			     {
			       serverinfo=>'ldaps://ldap.uvt.nl:636 ; o=Universiteit van Tilburg, c=NL',
			       dumpsearch=>1,
			       encodefilter=>0,
			     }
			     );
  die "ldaperror",$ldap->error() if ($ldap->error);

  my $msg=$ldap->search("uid=smith");
  if ($msg->code())
  {
     die $msg->error() ;
  }


=head1 BUGS



=head1 SUPPORT
huh?


=head1 AUTHOR

	Anton Sluijtman
	anton@uvt.nl

=head1 COPYRIGHT

This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

The full text of the license can be found in the
LICENSE file included with this module.


=head1 SEE ALSO

perl(1).

=cut

