#! /usr/bin/env perl

use strict;
use warnings FATAL => 'all';

use Module::Build;
use File::Find;

do {
	open my $fh, '>', 'MANIFEST' or die "open(MANIFEST): $!\n";
	find({wanted => sub { -f or return; print $fh "$_\n" or die "write(MANIFEST): $!\n" }, no_chdir => 1, follow => 0}, 'lib');
	close $fh or die "close(MANIFEST): $!\n";
};

my $build = new Module::Build(
	module_name => 'Class::Lazy',
	dist_name => 'libclass-lazy-perl',
	dist_version => '0.0',
	dist_abstract => 'delayed OO class loading',
	dist_author => 'Wessel Dankers <wsl@fruit.je>',
	license => 'perl',
	create_makefile_pl => 'small',
);

$build->create_build_script;
