#!/usr/bin/env perl

package UvT::Vlan;

$VERSION     = 1.00;
@ISA         = qw(Exporter);
@EXPORT      = ();
@EXPORT_OK   = qw(ip2vlan, host2vlan, readvlans);
%EXPORT_TAGS = ( DEFAULT => [qw(&ip2vlan, &host2vlan, &readvlans)]);

use Exporter;
use Data::Dumper;
use NetAddr::IP;

use strict;
use warnings;

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);


# Zoek het vlan van dit systeem op
# todo:
#  - wat als IPv4 en IPv6 in verschillende vlans zitten?
#  - cli-optie om vlan te overriden?



my $urukvlans="../../../../group/uruk/etc/uruk/vlans";

# Lees uruk vlans in het formaat: "my_vlan6_xc=2001:610:1410:200::/64
# Returned een hash van arrays met de vlan naam als key;
# key   =>  [ array of NetAddr:IP ];
# 'xm'  =>  [ '137.56.246.0/24', '2001:610:1410:480::/64 ];
sub readvlans {
	my %vlans;
	if (open(my $fh, '<:encoding(UTF-8)', $urukvlans)) {
		while (my $row = <$fh>) {
			chomp $row;
			if ($row =~ m/my_vlan6?_([^=]+)=(.+)/) {
				push(@{$vlans{$1}}, NetAddr::IP->new($2));
			}
		}
	} else {
		die("Unable to open file $urukvlans.\nError: $!");
	}
	#print "vlans: ",Dumper(%vlans),"\n";
	return %vlans;
}

sub printvlans {
	my %vlans = readvlans();
	while ( (my ($name, $netblocks) = each(%vlans)) ) {
		print "$name=",join(',', @{$netblocks}),"\n";
	}
}


# zoek het juiste vlan bij een IP-adres
sub ip2vlan {
	my $ip = NetAddr::IP->new(@_);
	my %vlans = readvlans();

	while ( (my ($name, $netblocks) = each(%vlans)) ) {
		foreach my $netblock (@{$netblocks}) {
			return "$name" if $ip->within($netblock);
		}
	}
	return;
}

# remove leading and trailing whitespace
sub trim { my $s = shift; $s =~ s/^\s+|\s+$//g; return $s };

# Zoek de IP-adressen voor dit systeem
# todo: netwerkcode netjes maken
# - bv iets met getaddrinfo # http://backreference.org/2014/12/11/some-common-networking-operations-in-perl/
# - verstandig omgaan met meerdere IP-adressen
sub getip {
	my ($hostname) = @_;
	my @ips = ();
	my $ipv4=`dig +short +domain=uvt.nl -t A    $hostname`;
	my $ipv6=`dig +short +domain=uvt.nl -t AAAA $hostname`;
	$ipv4 = NetAddr::IP->new(trim($ipv4));
	$ipv6 = NetAddr::IP->new(trim($ipv6));
	die ("No IP-adddress found for host $hostname.\n") if ( ! $ipv4  && ! $ipv6);
	push(@ips, $ipv4) if ($ipv4);
	push(@ips, $ipv6) if ($ipv6);
	return @ips;
}

# zoek het juiste vlan bij een hostname
sub host2vlan {
	my ($hostname) = @_;
	my (@ips) = getip($hostname);

#	print "h2v host: $hostname\n";
#	print Dumper(@ips);

	foreach my $ip (@ips) {
#		print "h2v ip: $ip\n";
		my $vlan = ip2vlan($ip);
#		print "h2v vlan: $vlan\n";
		return $vlan if ($vlan);
	}


}
1;

#print UvT::Vlan::host2vlan($ARGV[0]),"\n";
#print UvT::Vlan::ip2vlan($ARGV[0]),"\n";
UvT::Vlan::printvlans()
