<?php

/**
 * @file
 * Process theme data.
 *
 * Use this file to run your theme specific implimentations of theme functions,
 * such preprocess, process, alters, and theme function overrides.
 *
 * Preprocess and process functions are used to modify or create variables for
 * templates and theme functions. They are a common theming tool in Drupal,
 * often used as an alternative to directly editing or adding code to
 * templates. Its worth spending some time to learn more about these functions -
 * they are a powerful way to easily modify the output of any template variable.
 *
 * Preprocess and Process Functions SEE:
 * http://drupal.org/node/254940#variables-processor
 * 1. Rename each function and instance of "sitebuilder_uvt" to match your
 *    subthemes name, e.g. if your theme name is "footheme" then the function
 *    name will be "footheme_preprocess_hook". Tip - you can search/replace on
 *    "sitebuilder_uvt".
 * 2. Uncomment the required function to use.
 */

/**
 * Override or insert variables for the page templates.
 */
function sitebuilder_uvt_preprocess_page(&$vars) {
  // Provide a variable to all templates to test for a mobile context, this
  // requires the Browscap module and returns TRUE or FALSE.
}

/**
 * Shows listing of asset metadata.
 *
 * The theme used to generate a listing of metadata in the views using
 * mediamosa_ck_views_field_text_metadata. Slightly modified from the original:
 * no showing of empty rows.
 *
 * @param array $variables
 *   Data used for the theme.
 */
function sitebuilder_uvt_mediamosa_ck_views_theme_asset_metadata($variables) {
  $rows = array();
  ksort($variables['metadata']);

  foreach ($variables['metadata'] as $name => $value) {
    if ($name == 'source') {
      $name = t('Retention period');
    }
    $name = drupal_ucfirst(str_replace('_', ' ', $name));

    if (is_array($value)) {
      $value = implode("\n", $value);
    }
    if ((strtolower($name) == 'created') and (isset($value)) and (substr($value, -9) == ' 00:00:00')) {
      $value = substr($value, 0, -9);
      $value = date('d-m-Y', strtotime((string) $value));
    }

    if (empty($value)) {
      $rows[] = array(
        'class' => array('empty'), 'data' => array('name' => $name, 'value' => ''),
      );
    }
    else {
      $rows[] = array('name' => $name, 'value' => (empty($value) ? ' ' : nl2br(check_plain($value))));
    }
  }
  if (empty($rows)) {
    $rows[] = array('-', '');
  }

  return theme('table', array('rows' => $rows));
}

/**
 * Returns HTML for the Powered by MediaMosa.
 *
 * @ingroup themeable
 */
function sitebuilder_uvt_mediamosa_sb_powered_by_mediamosa() {
  $image = theme('image', array(
             'path' => drupal_get_path('module', 'mediamosa_sb') . '/images/logo32.png',
             'alt' => t('Powered by MediaMosa'),
             'title' => t('Powered by MediaMosa'),
           )
  );
  $output = '<div class="mediamosa-logo-small">';
  $output .= l($image, 'http://mediamosa.org', array('attributes' => array(), 'html' => TRUE));
  $output .= '</div>';
  return $output;
}


/**
 * Implements template_process_html().
 *
 * Override or insert variables into the page template for HTML output.
 */
function sitebuilder_uvt_process_html(&$variables) {
  // Hook into color.module.
  if (module_exists('color')) {
    _color_html_alter($variables);
  }
}

/**
 * Implements template_process_page().
 */
function sitebuilder_uvt_process_page(&$variables, $hook) {
  // Hook into color.module.
  if (module_exists('color')) {
    _color_page_alter($variables);
  }
}

/**
 * Implements mediamosa_ck_views_field_text_mediafiles().
 */
function sitebuilder_uvt_mediamosa_ck_views_theme_asset_mediafiles($variables) {
  $output = array();

  if (empty($variables['mediafiles'])) {
    return t('There are no other formats available');
  }

  // Complex UvT rules for showing the formatslist.
  // Array to compare not equal filenames without ext.
  $filelist_noext = array();
  // Array to compare equal filenames.
  $filelist = array();
  // Loop.
  foreach ($variables['mediafiles'] as $mediafile) {

    // Skip originals.
    if ($mediafile['is_original_file'] == 'TRUE') {
      continue;
    }

    if (empty($mediafile['metadata']['mime_type'])) {
      // Not analysed.
      continue;
    }

    // Skip doubles (the part before extention).
    $filename_withoutext = preg_replace('/\\.[^.\\s]{3,4}$/', '', $mediafile['filename']);
    $ext = pathinfo($mediafile['filename'], PATHINFO_EXTENSION);
    if ((isset($filelist_noext[$filename_withoutext])) and ($ext != 'jpg')) {
      continue;
    }

    $filename_display = trim($mediafile['filename']);
    if (($ext == 'jpg') and isset($mediafile['metadata']['height']) and isset($mediafile['metadata']['width'])) {
      $filename_display .= strtr(' (@widthx@height)', array('@width' => $mediafile['metadata']['width'], '@height' => $mediafile['metadata']['height']));
    }
    // Also skip identical images.
    if ((isset($filelist[$filename_display])) and ($ext == 'jpg')) {
      continue;
    }
    // Store to compare.
    $filelist_noext[$filename_withoutext] = $filename_withoutext;
    $filelist[$filename_display] = $filename_display;

    // Build the link.
    $path = strtr($variables['asset_path'], array('[asset_id]' => $mediafile['asset_id'], '[mediafile_id]' => $mediafile['mediafile_id']));

    // Get filename.
    $output[] = '<li>';
    $output[] = empty($mediafile['filename']) ? t('No filename present') : (l($filename_display, $path));
    $output[] = '</li>';
  }

  return empty($output) ? '' : '<ul>' . implode('', $output) . '</ul>';
}
