<?php
// Mediasite EDAS webservice client wrapper


include_once "edasproxy.php";

class ExternalAccessClient
{
    var $proxy;
    var $ImpersonationUsername;
    var $Ticket;
		
	function ExternalAccessClient($serviceLocation, $ticket=null)
	{
		// define the WSDL to class map
		$edas_class_map = array(
			"loginRequest" => "loginRequest",
			"LoginResult" => "LoginResult",
			"getVersionRequest" => "getVersionRequest",
			"GetVersionResult" => "GetVersionResult",
			"testRequest" => "testRequest",
			"TestResult" => "TestResult",
			"RequestMessage" => "RequestMessage",
			"queryPresentationDetailsRequest" => "queryPresentationDetailsRequest",
			"ArrayOfString" => "ArrayOfString",
			"QueryPresentationDetailsFilter" => "QueryPresentationDetailsFilter",
			"QueryPresentationDetailsResult" => "QueryPresentationDetailsResult",
			"ArrayOfPresentationDetails" => "ArrayOfPresentationDetails",
			"PresentationDetails" => "PresentationDetails",
			"ArrayOfPresenterContext" => "ArrayOfPresenterContext",
			"MediasiteContext" => "MediasiteContext",
			"PresenterContext" => "PresenterContext",
			"MediaEncodeProfileDetails" => "MediaEncodeProfileDetails",
			"ArrayOfVideoEncodingDetails" => "ArrayOfVideoEncodingDetails",
			"VideoEncodingDetails" => "VideoEncodingDetails",
			"AudioEncodingDetails" => "AudioEncodingDetails",
			"ArrayOfAudioEncodingDetails" => "ArrayOfAudioEncodingDetails",
			"SlideCaptureDetails" => "SlideCaptureDetails",
			"StabilizationDetails" => "StabilizationDetails",
			"ArrayOfSupportingLink" => "ArrayOfSupportingLink",
			"SupportingLink" => "SupportingLink",
			"ArrayOfPresentationAttachment" => "ArrayOfPresentationAttachment",
			"PresentationAttachment" => "PresentationAttachment",
			"queryTimeZonesRequest" => "queryTimeZonesRequest",
			"QueryTimeZonesResult" => "QueryTimeZonesResult",
			"ArrayOfTimeZoneContext" => "ArrayOfTimeZoneContext",
			"TimeZoneContext" => "TimeZoneContext",
			"queryMediaEncodeProfilesRequest" => "queryMediaEncodeProfilesRequest",
			"QueryMediaEncodeProfilesResult" => "QueryMediaEncodeProfilesResult",
			"ArrayOfMediaEncodeProfileContext" => "ArrayOfMediaEncodeProfileContext",
			"MediaEncodeProfileContext" => "MediaEncodeProfileContext",
			"queryPresentersRequest" => "queryPresentersRequest",
			"QueryPresentersResult" => "QueryPresentersResult",
			"queryServerGroupsRequest" => "queryServerGroupsRequest",
			"QueryServerGroupsResult" => "QueryServerGroupsResult",
			"ArrayOfServerGroupContext" => "ArrayOfServerGroupContext",
			"ServerGroupContext" => "ServerGroupContext",
			"queryPlayersRequest" => "queryPlayersRequest",
			"QueryPlayersResult" => "QueryPlayersResult",
			"ArrayOfPlayerContext" => "ArrayOfPlayerContext",
			"PlayerContext" => "PlayerContext",
			"createPresentationRequest" => "createPresentationRequest",
			"CreatePresentationDetails" => "CreatePresentationDetails",
			"CreatePresentationResult" => "CreatePresentationResult",
			"PresentationContext" => "PresentationContext",
			"queryPresentationsRequest" => "queryPresentationsRequest",
			"FolderFilter" => "FolderFilter",
			"PresentationFilter" => "PresentationFilter",
			"ArrayOfPresentationDataStatus" => "ArrayOfPresentationDataStatus",
			"QueryPresentationsResult" => "QueryPresentationsResult",
			"ArrayOfPresentationContext" => "ArrayOfPresentationContext",
			"querySlidesRequest" => "querySlidesRequest",
			"QuerySlidesResult" => "QuerySlidesResult",
			"ArrayOfSlide" => "ArrayOfSlide",
			"Slide" => "Slide",
			"queryTimeZoneDetailsRequest" => "queryTimeZoneDetailsRequest",
			"QueryTimeZoneDetailsResult" => "QueryTimeZoneDetailsResult",
			"ArrayOfTimeZoneDetails" => "ArrayOfTimeZoneDetails",
			"TimeZoneDetails" => "TimeZoneDetails",
			"queryPresenterDetailsRequest" => "queryPresenterDetailsRequest",
			"QueryPresenterDetailsResult" => "QueryPresenterDetailsResult",
			"ArrayOfPresenterDetails" => "ArrayOfPresenterDetails",
			"PresenterDetails" => "PresenterDetails",
			"queryMediaEncodeProfileDetailsRequest" => "queryMediaEncodeProfileDetailsRequest",
			"QueryMediaEncodeProfileDetailsResult" => "QueryMediaEncodeProfileDetailsResult",
			"ArrayOfMediaEncodeProfileDetails" => "ArrayOfMediaEncodeProfileDetails",
			"queryChapterPointsRequest" => "queryChapterPointsRequest",
			"QueryChapterPointsResult" => "QueryChapterPointsResult",
			"ArrayOfChapterPoint" => "ArrayOfChapterPoint",
			"ChapterPoint" => "ChapterPoint",
			"queryFolderDetailsRequest" => "queryFolderDetailsRequest",
			"QueryFolderDetailsResult" => "QueryFolderDetailsResult",
			"ArrayOfFolderDetails" => "ArrayOfFolderDetails",
			"FolderDetails" => "FolderDetails",
			"logoutRequest" => "logoutRequest",
			"LogoutResult" => "LogoutResult",
			"queryPresentationTemplatesRequest" => "queryPresentationTemplatesRequest",
			"QueryPresentationTemplatesResult" => "QueryPresentationTemplatesResult",
			"ArrayOfPresentationTemplateContext" => "ArrayOfPresentationTemplateContext",
			"PresentationTemplateContext" => "PresentationTemplateContext",
			"queryPresentationTemplateDetailsRequest" => "queryPresentationTemplateDetailsRequest",
			"QueryPresentationTemplateDetailsResult" => "QueryPresentationTemplateDetailsResult",
			"ArrayOfPresentationTemplateDetails" => "ArrayOfPresentationTemplateDetails",
			"PresentationTemplateDetails" => "PresentationTemplateDetails",
			"createPresentationFromTemplateRequest" => "createPresentationFromTemplateRequest",
			"CreatePresentationFromTemplateDetails" => "CreatePresentationFromTemplateDetails",
			"CreatePresentationFromTemplateResult" => "CreatePresentationFromTemplateResult",
			"querySitePropertiesRequest" => "querySitePropertiesRequest",
			"QuerySitePropertiesResult" => "QuerySitePropertiesResult",
			"SiteProperties" => "SiteProperties",
			"queryContentServerDetailsRequest" => "queryContentServerDetailsRequest",
			"QueryContentServerDetailsResult" => "QueryContentServerDetailsResult",
			"ArrayOfContentServerDetails" => "ArrayOfContentServerDetails",
			"ContentServerDetails" => "ContentServerDetails",
			"ArrayOfContentServerEndpoint" => "ArrayOfContentServerEndpoint",
			"ContentServerEndpoint" => "ContentServerEndpoint",
			"queryResourcePermissionsRequest" => "queryResourcePermissionsRequest",
			"ArrayOfResourceObjectRequest" => "ArrayOfResourceObjectRequest",
			"ResourceObjectRequest" => "ResourceObjectRequest",
			"QueryResourcePermissionsResult" => "QueryResourcePermissionsResult",
			"ArrayOfResourceObjectResponse" => "ArrayOfResourceObjectResponse",
			"ResourceObjectResponse" => "ResourceObjectResponse",
			"queryResourcePermissionListRequest" => "queryResourcePermissionListRequest",
			"QueryResourcePermissionListResult" => "QueryResourcePermissionListResult",
			"ResourcePermission" => "ResourcePermission",
			"ArrayOfResourcePermissionEntry" => "ArrayOfResourcePermissionEntry",
			"ResourcePermissionEntry" => "ResourcePermissionEntry",
			"queryFoldersWithPresentationsRequest" => "queryFoldersWithPresentationsRequest",
			"QueryFoldersWithPresentationsResult" => "QueryFoldersWithPresentationsResult",
			"querySubFolderDetailsRequest" => "querySubFolderDetailsRequest",
			"QuerySubFolderDetailsResult" => "QuerySubFolderDetailsResult",
			"queryAllPresentationsRequest" => "queryAllPresentationsRequest",
			"QueryAllPresentationsResult" => "QueryAllPresentationsResult",
			"createAuthTicketRequest" => "createAuthTicketRequest",
			"CreateAuthTicketSettings" => "CreateAuthTicketSettings",
			"CreateAuthTicketResult" => "CreateAuthTicketResult",
			"removeAuthTicketRequest" => "removeAuthTicketRequest",
			"RemoveAuthTicketResult" => "RemoveAuthTicketResult",
			"queryAuthTicketPropertiesRequest" => "queryAuthTicketPropertiesRequest",
			"QueryAuthTicketPropertiesResult" => "QueryAuthTicketPropertiesResult",
			"AuthTicketProperties" => "AuthTicketProperties",
			"createPresenterRequest" => "createPresenterRequest",
			"CreatePresenterDetails" => "CreatePresenterDetails",
			"CreatePresenterResult" => "CreatePresenterResult",
			"createFolderRequest" => "createFolderRequest",
			"CreateFolderResult" => "CreateFolderResult",
			"queryCatalogSharesRequest" => "queryCatalogSharesRequest",
			"QueryCatalogSharesResult" => "QueryCatalogSharesResult",
			"ArrayOfCatalogShare" => "ArrayOfCatalogShare",
			"CatalogShare" => "CatalogShare");

			
		$this->proxy = new SoapClient($serviceLocation."?WSDL", array ("classmap" => $edas_class_map));         
		$this->Ticket = $ticket;		
	}

	function Version()
	{		
		$request = new getVersionRequest();
		$response = $this->proxy->GetVersion($request);
		
		return $response->Version;
	}	
  
	function Test()
	{
		$request = new testRequest();
		$response = $this->proxy->Test($request);
		
		return $response->Value;
	}

	function QuerySiteProperties()
	{
		$request = new querySitePropertiesRequest();
		$request->UserTicket = $this->Ticket;
		
		$response = $this->proxy->QuerySiteProperties($request);
		
		return $response->Properties;
	}


	function Login($username, $password)
	{
		$request = new loginRequest();
		$request->Username = $username;
		$request->Password = $password;

		$response = $this->proxy->Login($request);
		
		$this->Ticket = $response->UserTicket;
	}

	function LoginWithImpersonation($username, $password, $impersonationUsername)
	{
		$request = new loginRequest();
		$request->Username = $username;
		$request->Password = $password;
		$request->ImpersonationUsername	= $impersonationUsername;
		$response = $this->proxy->Login($request);
		$this->Ticket = $response->UserTicket;
	}

	function Logout($userTicket)
	{
		$request = new logoutRequest();
		$request->UserTicket = $userTicket;

		$response = $this->proxy->Logout($request);    
	}


	function QueryPresentationDetails($presentationIdList, $filter=null)
	{
		$request = new queryPresentationDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PresentationIdList = $presentationIdList;
		$request->PresentationFilter = $filter;
		
		$response = $this->proxy->QueryPresentationDetails($request);

		return $response->Details->PresentationDetails;        
	}

	function QueryTimeZones()
	{
		$request = new queryTimeZonesRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		
		$response = $this->proxy->QueryTimeZones($request);

		return $response->TimeZones->TimeZoneContext;
	}

	function QueryMediaEncodeProfiles()
	{
		$request = new queryMediaEncodeProfilesRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		
		$response = $this->proxy->QueryMediaEncodeProfiles($request);

		return $response->MediaEncodeProfiles->MediaEncodeProfileContext;
	}

	function QueryPresenters()
	{
		$request = new queryPresentersRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		
		$response = $this->proxy->QueryPresenters($request);

		return $response->Presenters->PresenterContext;
	}

	function QueryServerGroups()
	{
		$request = new queryServerGroupsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		
		$response = $this->proxy->QueryServerGroups($request);

		return $response->ServerGroups->ServerGroupContext;
	}

	function QueryPlayers()
	{
		$request = new queryPlayersRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		
		$response = $this->proxy->QueryPlayers($request);

		return $response->Players->PlayerContext;
	}

	function CreatePresentation($creationDetails)
	{
		if(!isset($creationDetails->FolderId))
		{
			$creationDetails->FolderId = '';
		}
		
		$request = new createPresentationRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->CreationDetails = $creationDetails;

		$response = $this->proxy->CreatePresentation($request);

		return $response->Presentation;    
	}

	function QueryPresentations($folderIdList, $presentationFilter=null)
	{
		if($presentationFilter == null)
		{
			$presentationFilter = new PresentationFilter();
			$presentationFilter->PermissionMask = 'Read';
			$presentationFilter->FolderMask = 'Normal';
		}
		
		$request = new queryPresentationsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->FolderIdList = $folderIdList;
		$request->PresentationFilter = $presentationFilter;

		$response = $this->proxy->QueryPresentations($request);

		return $response->Presentations->PresentationContext;  
	}

	function QuerySlides($presentationId, $startIndex, $count)
	{
		$request = new querySlidesRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PresentationId = $presentationId;
		$request->StartIndex = $startIndex;
		$request->Count = $count;

		$response = $this->proxy->QuerySlides($request);

		return $response->Slides->Slide;
	}

	function QueryTimeZoneDetails($timezoneIdList)
	{
		$request = new queryTimeZoneDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->TimeZoneIdList = $timezoneIdList;
			
		$response = $this->proxy->QueryTimeZoneDetails($request);

		return $response->Details->TimeZoneDetails;
	}

	function QueryPresenterDetails($presenterIdList)
	{
		$request = new queryPresenterDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PresenterIdList = $presenterIdList;

		$response = $this->proxy->QueryPresenterDetails($request);

		return $response->Details->PresenterDetails;
	}

	function QueryMediaEncodeProfileDetails($profileIdList)
	{
		$request = new queryMediaEncodeProfileDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->MediaEncodeProfileIdList = $profileIdList;

		$response = $this->proxy->QueryMediaEncodeProfileDetails($request);

		return $response->Details->MediaEncodeProfileDetails; 
	}

	function QueryChapterPoints($presentationId, $startIndex, $count)
	{		
		$request = new queryChapterPointsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PresentationId = $presentationId;
		$request->StartIndex = $startIndex;
		$request->Count = $count;

		$response = $this->proxy->QueryChapterPoints($request);    

		return $response->ChapterPoints->ChapterPoint;
	}

	function QueryFolderDetails($folderIdList, $permissionMask="Read")
	{
		$request = new queryFolderDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->FolderIdList = $folderIdList;
		$request->PermissionMask = $permissionMask;

		$response = $this->proxy->QueryFolderDetails($request);

		return $response->Details->FolderDetails;
	}

	function QueryPresentationTemplates()
	{
		$request = new queryPresentationTemplatesRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		
		$response = $this->proxy->QueryPresentationTemplates($request);

		return $response->Templates->PresentationTemplateContext;
	}

	function QueryPresentationTemplateDetails($presentationTemplateIdList)
	{
		$request = new queryPresentationTemplateDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PresentationTemplateIdList = $presentationTemplateIdList;

		$response = $this->proxy->QueryPresentationTemplateDetails($request);

		return $response->Details->PresentationTemplateDetails;
	}

	function CreatePresentationFromTemplate($creationDetails)
	{
		if(!isset($creationDetails->FolderId))
		{
			$creationDetails->FolderId = '';
		}
		
		$request = new createPresentationFromTemplateRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->CreationDetails = $creationDetails;

		$response = $this->proxy->CreatePresentationFromTemplate($request);

		return $response->Presentation;
	}

	function QueryContentServerDetailsByPresentation($presentationId, $includeStorageSettings)
	{
		$request = new queryContentServerDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->QueryBy = "Presentation";
		$request->PresentationId = $presentationId;
		$request->IncludeStorageSettings = $includeStorageSettings;

		$response = $this->proxy->QueryContentServerDetails($request);

		return $response->Details->ContentServerDetails;
	}

	function QueryContentServerDetailsByServerType($serverType, $includeStorageSettings)
	{
		$request = new queryContentServerDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->QueryBy = "ServerType";
		$request->ServerType = $serverType;
		$request->IncludeStorageSettings = $includeStorageSettings;

		$response = $this->proxy->QueryContentServerDetails($request);

		return $response->Details->ContentServerDetails;
	}

	function QueryResourcePermissions($resourceList, $impersonationUsername=null)
	{
		$request = new queryResourcePermissionsRequest();
		$request->UserTicket = $this->Ticket;
		
		if($impersonationUsername == null)
		{
			$request->ImpersonationUsername = $this->ImpersonationUsername;    
		}
		else
		{
			$request->ImpersonationUsername = $impersonationUsername;
		}
		
		$request->ResourceList = $resourceList;

		$response = $this->proxy->QueryResourcePermissions($request);
		
		return $response->ResourceList->ResourceObjectResponse;
	}

	function QueryResourcePermissionList($id, $resourceType)
	{
		$resource = new ResourceObjectRequest();
		$resource->Id = $id;
		$resource->Type = $resourceType;
		
		$request = new queryResourcePermissionListRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->Resource = $resource;

		$response = $this->proxy->QueryResourcePermissionList($request);

		return $response->ResourcePermission;
	}

	function QueryFoldersWithPresentation($impersonationUsername=null)
	{
		$request = new queryFoldersWithPresentationsRequest();
		$request->UserTicket = $this->Ticket;
		
		if($impersonationUsername == null)
		{
			$request->ImpersonationUsername = $this->ImpersonationUsername;    
		}
		else
		{
			$request->ImpersonationUsername = $impersonationUsername;	
		}
		
		$response = $this->proxy->QueryFoldersWithPresentations($request); 

		return $response->Folders->FolderDetails;
	}

	function QuerySubFolderDetails($parentFolderIdList, $includeAllSubFolders, $permissionMask="Read")
	{  	
		$request = new querySubFolderDetailsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->ParentFolderIdList = $parentFolderIdList;
		$request->IncludeAllSubFolders = $includeAllSubFolders;
		$request->PermissionMask = $permissionMask;

		$response = $this->proxy->QuerySubFolderDetails($request);

		return $response->Folders->FolderDetails;
	}

	function QueryAllPresentations($presentationFilter)
	{
		$request = new queryAllPresentationsRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PresentationFilter = $presentationFilter;

		$response = $this->proxy->QueryAllPresentations($request);

		return $response->Presentations->PresentationContext;   
	}

	function CreateAuthTicket($username, $resourceId, $clientIpAddress, $minutesToLive)
	{
		$settings = new CreateAuthTicketSettings();
		$settings->Username = $username;
		$settings->ResourceId = $resourceId;
		$settings->ClientIpAddress = $clientIpAddress;
		$settings->MinutesToLive = $minutesToLive;

		$request = new createAuthTicketRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;
		$request->TicketSettings = $settings;

		$response = $this->proxy->CreateAuthTicket($request);

		return $response->AuthTicketId;
	}

	function RemoveAuthTicket($authTicketId)
	{
		$request = new removeAuthTicketRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->AuthTicketId = $authTicketId;

		$response = $this->proxy->RemoveAuthTicket($request);
	}

	function QueryAuthTicketProperties($authTicketId, $minutesToLive=null)
	{
		$request = new queryAuthTicketPropertiesRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->AuthTicketId = $authTicketId;
		$request->RenewTicket = !($minutesToLive == null);
		$request->MinutesToLive = $minutesToLive;

		$response = $this->proxy->QueryAuthTicketProperties($request);

		return $response->Properties;
	}

	function CreatePresenter($createDetails)
	{
		$request = new createPresenterRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PresenterDetails = $createDetails;

		$response = $this->proxy->CreatePresenter($request);

		return $response->PresenterId;
	}

	function CreateFolder($parentId, $name, $description)
	{
		$request = new createFolderRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->ParentId = $parentId;
		$request->Name = $name;
		$request->Description = $description;

		$response = $this->proxy->CreateFolder($request);

		return $response->Id;
	}

	function QueryCatalogShares($permissionMask)
	{
		$request = new queryCatalogSharesRequest();
		$request->UserTicket = $this->Ticket;
		$request->ImpersonationUsername = $this->ImpersonationUsername;    
		$request->PermissionMask = $permissionMask;

		$response = $this->proxy->QueryCatalogShares($request);

		return $response->Shares->CatalogShare;
	}
}

?>