<?php 

function mediasite_add_instance($mediasite) {
	global $DB;
    $mediasite->timecreated = time();
    return $DB->insert_record("mediasite", $mediasite);
}

function mediasite_update_instance($mediasite) {
	global $DB;
    $mediasite->id = $mediasite->instance;
    $mediasite->timemodified = time();

    return $DB->update_record("mediasite", $mediasite);
}

function mediasite_get_coursemodule_info($coursemodule) {
    global $CFG;
	global $DB;
    $info = NULL;

    if ($mediasite = $DB->get_record('mediasite', array('id' => $coursemodule->instance))) {
        $info = new object();        
        $info->name = $mediasite->name ;
        if ($mediasite->openaspopup == '1') {
	        $fullurl = "$CFG->wwwroot/mod/mediasite/view.php?id=$coursemodule->id&redirect=1&inpopup=true";
    	    $width  = 1024 ;
	        $height = 768 ;
    	    $wh = "width=$width,height=$height,toolbar=no,location=no,menubar=no,copyhistory=no,status=no,directories=no,scrollbars=yes,resizable=yes";
	        $info->extra = "onclick=\"window.open('$fullurl', '', '$wh'); return false;\"";
        }
    }

    return $info;    	
}

function mediasite_delete_instance($id) {
	global $DB;
    if (! $mediasite = $DB->get_record("mediasite", array("id" =>$id))) {
        return false;
    }

    $result = true;

    if (! $DB->delete_records("mediasite", array("id" => $mediasite->id))) {
        $result = false;
    }

    return $result;
}

function mediasite_user_outline($course, $user, $mod, $mediasite) {
    return $return;
}

function mediasite_user_complete($course, $user, $mod, $mediasite) {
    return true;
}

function mediasite_print_recent_activity($course, $isteacher, $timestart) {
    global $CFG;

    return false;  //  True if anything was printed, otherwise false 
}

function mediasite_cron () {
    global $CFG;

    return true;
}

function mediasite_grades($mediasiteid) {
   return NULL;
}

function mediasite_get_participants($mediasiteid) {
    return false;
}

function mediasite_scale_used ($mediasiteid,$scaleid) {
    $return = false;
   
    return $return;
}

function mediasite_scale_used_anywhere($scaleid) {
    if ($scaleid and record_exists('mediasite', 'grade', -$scaleid)) {
        return true;
    } else {
        return false;
    }
}

function mediasite_supports($feature) {
    switch($feature) {
        case FEATURE_GROUPS:                  return false;
        case FEATURE_GROUPINGS:               return false;
        case FEATURE_GROUPMEMBERSONLY:        return false;
        case FEATURE_MOD_INTRO:               return false;
        case FEATURE_BACKUP_MOODLE2:          return false;
        case FEATURE_COMPLETION_TRACKS_VIEWS: return false;
        case FEATURE_GRADE_HAS_GRADE:         return false;
        case FEATURE_GRADE_OUTCOMES:          return false;

        default: return null;
    }
}

function mediasite_extend_navigation($navigation, $course, $module, $cm) {
    $navigation->mainnavonly = true;

}	

?>
