<?php
    require_once('../../config.php');
    require_once("$CFG->dirroot/mod/mediasite/search_form.php");
    require_once("$CFG->dirroot/mod/mediasite/locallib.php");

    global $PAGE;
 
    $courseid = required_param('course', PARAM_INT);   // course
	$context = get_context_instance(CONTEXT_COURSE, $courseid);
    require_login();
	require_capability('mod/mediasite:searchforcontent', $context);

	$PAGE->set_url($CFG->wwwroot . '/mod/mediasite/search.php');
    html_header();

    $mform =& new mod_mediasite_search_form(strval($courseid), compact('cm', 'mediasite', 'hook', 'mode', 'e', 'context'));

    if ($mform->is_cancelled()) {
        ?>
        <script type="text/javascript">
        //<![CDATA[
        window.close();
        //]]>
        </script>
        <?php
        exit;
    }

    if ($data = $mform->get_data()) {
        global $USER;

        ?>
        <script type="text/javascript">
        //<![CDATA[
        function set_value(name, id, resourcetype) {
            opener.document.getElementById('id_name').value = name;
            opener.document.getElementById('id_resourceid').value = id;
            opener.document.getElementById('id_resourcetype').value = resourcetype;
            window.close();
        }
        //]]>
        </script>
        <?php

        $mform->display();
        $results = mediasite_search($data->searchtext,$data->resourcetype,$USER->username);		
        $selectlabel = get_string('mediasitesearchchoose','mediasite');
        
        if(count($results) > 0) {
            foreach($results as $result) {
                $table->data[] = get_result_item($result, $data->resourcetype, $selectlabel);
            }
        }
        
        if(isset($table)) {
            print_table($table);
        }
        else {
            echo get_string('mediasitesearchnoresult','mediasite');
        }
    }
    else
    {
        $mform->display();
    }

    html_footer();

    function get_result_item($result, $resourcetype, $selectlabel) {        
        $escapedname = str_replace("'","\'",$result->Name);
        $escapedname = str_replace('"', "'+String.fromCharCode(34)+'", $escapedname);
        $link = "<strong><a onclick=\"return set_value('$escapedname','$result->Id','$resourcetype')\" href=\"#\">$selectlabel</a></strong>";
        return array ($link, format_string($result->Name));                                    
    }

    function html_header() {
        print_header();
        echo "<table border=\"0\" style=\"margin-left:auto;margin-right:auto\" cellspacing=\"3\" cellpadding=\"3\" width=\"640\">";
        echo "<tr>";
        echo "<td colspan=\"2\">";
    }

    function html_footer() {
        global $COURSE, $OUTPUT;

        echo '</td></tr></table>';

        echo $OUTPUT->footer($COURSE);
    }

?>