/*
 * Decompiled with CFR 0.152.
 */
package Display;

import Display.LanguageManager;
import Output.OutputFormat;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FormatChooser
extends JFrame {
    private int type;
    private Document configFile;
    private Element lang;
    private Element format;
    private OutputFormat output;
    private LanguageManager langMan;
    private SAXBuilder builder;
    private List formats;
    private List langs;
    private JButton jButtonOK;
    private JList jListFiles;
    private JScrollPane jScrollPane1;

    public FormatChooser(URL appletCodeBase, int type, OutputFormat output, LanguageManager langMan) {
        this.initComponents();
        this.type = type;
        this.output = output;
        this.langMan = langMan;
        this.builder = new SAXBuilder();
        try {
            URL path = new URL(appletCodeBase + "Config.xml");
            this.configFile = this.builder.build(path);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "Error reading config file", "DragMath", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Error reading config file", "DragMath", 0);
        }
        catch (JDOMException ex) {
            JOptionPane.showMessageDialog(null, "Error reading config file", "DragMath", 0);
        }
        if (this.configFile != null) {
            Element temp;
            Object[] files;
            if (type == 0) {
                this.format = this.configFile.getRootElement();
                this.format = this.format.getChild("Formats");
                this.formats = this.format.getChildren("Format");
                files = new Object[this.formats.size()];
                for (int i = 0; i < this.formats.size(); ++i) {
                    temp = (Element)this.formats.get(i);
                    files[i] = temp.getAttributeValue("displayName");
                }
                this.jListFiles.setListData(files);
            }
            if (type == 1) {
                this.lang = this.configFile.getRootElement();
                this.lang = this.lang.getChild("Languages");
                this.langs = this.lang.getChildren("Lang");
                files = new Object[this.langs.size()];
                for (int i = 0; i < this.langs.size(); ++i) {
                    temp = (Element)this.langs.get(i);
                    files[i] = temp.getAttributeValue("displayName");
                }
                this.jListFiles.setListData(files);
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListFiles = new JList();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("DragMath");
        this.setResizable(false);
        this.jListFiles.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jListFiles);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                FormatChooser.this.jButtonOKMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap(21, Short.MAX_VALUE).add(layout.createParallelGroup(2).add(this.jButtonOK, -2, 59, -2).add(this.jScrollPane1, -2, 186, -2)).add(18, 18, 18)));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap(19, Short.MAX_VALUE).add(this.jScrollPane1, -2, 174, -2).add(15, 15, 15).add(this.jButtonOK).addContainerGap()));
        this.pack();
    }

    private void jButtonOKMouseClicked(MouseEvent evt) {
        Element temp;
        String fileName;
        int index;
        if (this.type == 0 && (index = this.jListFiles.getSelectedIndex()) != -1 && (fileName = (temp = (Element)this.formats.get(index)).getAttributeValue("fileName")) != null) {
            this.output.readFormatFile(fileName);
        }
        if (this.type == 1 && (index = this.jListFiles.getSelectedIndex()) != -1 && (fileName = (temp = (Element)this.langs.get(index)).getAttributeValue("fileName")) != null) {
            this.langMan.loadLanguageFile(fileName);
        }
        this.dispose();
    }
}

