#! /usr/bin/perl

use strict;
use warnings FATAL => 'all';

use Test::More;

BEGIN { use_ok('Xyzzy::Header') or BAIL_OUT('need Xyzzy::Header to run') }

my $h = new_ok('Xyzzy::Header') or BAIL_OUT('need a Xyzzy::Header object to run');

foreach my $str ('foo', 'foo=bar', 'foo=bar; baz=quux', 'foo; baz=quux', 'foo=bar; baz', 'foo:bar', 'foo:bar=baz:quux') {
	is(Xyzzy::Header->parse($str)->toString, $str, "parsing '$str' is reversible");
}

done_testing();
